# A Primer on Connecting to Data Sources[¶](https://knowledge.dataiku.com/latest/kb/exploration/connect-explore-data.html#a-primer-on-connecting-to-data-sources "Permalink to this headline")

## Connect to Your Existing Infrastructure[¶](https://knowledge.dataiku.com/latest/kb/exploration/connect-explore-data.html#connect-to-your-existing-infrastructure "Permalink to this headline")

SQL databases

The list of supported SQL databases, and information on how to connect to them, is available from our documentation on SQL datasets.

Hadoop HDFS

To connect you will first need to configure Hadoop on your instance. Please refer to the detailed guides on specific Hadoop distributions and managed services.

NoSQL

* Cassandra

* MongoDB

* ElasticSearch

## Accessing Cloud Storage and Databases[¶](https://knowledge.dataiku.com/latest/kb/exploration/connect-explore-data.html#accessing-cloud-storage-and-databases "Permalink to this headline")

Cloud File Storage

* Amazon S3

* Google Cloud Storage

* Azure Blob Storage

Cloud Databases

* Amazon Redshift. Syncing from S3 to Redshift is most efficient, and Dataiku DSS takes this route whenever possible, see this page for details.

* Google BigQuery is available through a JDBC driver developed by Simba.

* Snowflake

## Fetching Data From Remote Sources[¶](https://knowledge.dataiku.com/latest/kb/exploration/connect-explore-data.html#fetching-data-from-remote-sources "Permalink to this headline")

It is possible to fetch data using various protocols, and caching the resulting dataset on the filesystem.

* You can use an FTP server as an uncached database.

* You can also fetch data using HTTP, and use secured connections through SFTP or SCP.

## File Formats[¶](https://knowledge.dataiku.com/latest/kb/exploration/connect-explore-data.html#file-formats "Permalink to this headline")

Dataiku can read and write in various file formats for files-based connections: filesystem, HDFS, Amazon S3, HTTP, FTP, SSH… See the list of readable file formats.

## Accessing Data Through Plugins[¶](https://knowledge.dataiku.com/latest/kb/exploration/connect-explore-data.html#accessing-data-through-plugins "Permalink to this headline")

Many applications such as Google Sheets, SalesForce, Slack… provide capabilities to access their data through APIs. Dataiku DSS plugins allow the addition of custom connections leveraging these APIs to easily define datasets that fetch data from a wide variety of applications.

See the available plugins or create your own plugin.
