# Hands-On Tutorial: Dashboard Management[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#hands-on-tutorial-dashboard-management "Permalink to this headline")

Contents

* Let’s Get Started

+ Objectives

+ Prerequisites

* Resume/Create the Project

+ Use Case Summary

* Edit the Insight

* Filter the Dashboard

+ Add a Filters Tile

+ Use Filters in View Mode

+ Change the Default Selections in the Filter Tile

+ Share a Filtered Dashboard via the URL

+ Export a Filtered Dashboard as PDF

+ Understand Source Datasets for Filter Tiles

+ Use Sampling on Insights vs. Filter Tiles

* What’s Next?

Dashboards are key tools for visualizing data. Let’s explore how to use these native tools in Dataiku!

## Let’s Get Started[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#let-s-get-started "Permalink to this headline")

### Objectives[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#objectives "Permalink to this headline")

In this tutorial, you will:

* edit an insight within your dashboard,

* filter the dashboard,

* share a filtered dashboard,

* export it as PDF, and

* use sampling on insights versus filter tiles.

### Prerequisites[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#prerequisites "Permalink to this headline")

* A Dataiku 11 instance

* A minimum of Dataiku 11.3 to share a filtered dashboard via the URL or export it as PDF

* A basic level of knowledge about Dataiku is helpful. If you’ve never used Dataiku before, try the Core Designer learning path or a Quick Start tutorial!

## Resume/Create the Project[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#resume-create-the-project "Permalink to this headline")

If you completed all of the steps in the tutorial on charts and pivot tables, you can resume the same project for this lesson.

Alternatively, you can create a starter project with these same steps completed.

* From the Dataiku homepage, click **+New Project > DSS Tutorials > Visualization > Dashboards**.

### Use Case Summary[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#use-case-summary "Permalink to this headline")

This project is a simplified credit card fraud use case. Using data about transactions, merchants, and cardholders, we have a model that predicts which transactions should be authorized and which are potentially fraudulent.

For the target variable, *authorized\_flag*, a score of:

* 1 represents an authorized transaction.

* 0 is a transaction that failed authorization.

In this tutorial, let’s see how to edit the insights included in a dashboard, how to filter the data using filter tiles or samples, how to share a filtered dashboard and export it as PDF.

## Edit the Insight[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#edit-the-insight "Permalink to this headline")

Let’s edit the pivot table insight added to the Purchase Patterns dashboard.

*The video at the end of this section below walks through all the steps described here. Play and pause the video as you read the instructions and edit the dashboard.*

* From the top navigation bar, go to the **Dashboards** menu and open the **Purchase Patterns** dashboard.

* From the dashboard’s **View** tab, click the arrow next to the title of the pivot table to open the insight.

* Navigate to the insight’s **Edit** tab, and delete the FICO score filter.

* On the left, change the option to **Display measures as** rows to **Columns**. Click **Save**.

* Navigate back to the **View** tab of the insight or the dashboard to see the modified pivot table.

Note

If you return to *transactions\_known* dataset and find the pivot table used to create the insight, that pivot table will not have these changes since insights and charts are independent objects. You can learn more about chart insights in the product documentation.

## Filter the Dashboard[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#filter-the-dashboard "Permalink to this headline")

We often need to provide the end user of a dashboard the ability to interact with the insights on display. You can add data filters to an individual insight on its Edit tab, just like you would for a chart.

However, it’s also often useful to have a filter that operates at the level of an entire dashboard slide. This way, multiple insights on the same dashboard slide can be subject to the same data filters.

### Add a Filters Tile[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#add-a-filters-tile "Permalink to this headline")

Let’s demonstrate how a **filter tile** works at the dashboard slide level.

*The video at the end of this section walks through all the steps described here. Play and pause the video as you read the instructions and apply a filter tile.*

* From the dashboard’s **Edit** tab, click the blue **+** button to add a new tile.

* Choose a **Filters** tile.

The filters we add to the dashboard slide must reference a source dataset, and so we can choose this dataset in two ways.

* In this case, choose **Existing tile**, and in the **Source tile** option, select **Avg of purchase\_amount by item\_category and card\_fico\_score on transactions\_known** (i.e. the chart insight for the pivot table on *transactions\_known*).

* Choose *item\_category* as the column to use for the filter, and click **Add**.

* Adjust the size of the filter tile as needed, and click **Save**.

* Navigate back to the dashboard’s **View** tab to see the results. As you can see, by default, all item categories are selected.

### Use Filters in View Mode[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#use-filters-in-view-mode "Permalink to this headline")

Let’s see the filter tile in action!

* From the dashboard’s **View** tab, deselect categories **B**, **C**, and **D** from the filter tile.

It’s obvious that these categories have been removed from the pivot table, but the rows corresponding to these categories have also been removed from the bar chart and scatter plot since they are found on the same dashboard slide.

* In the filter tile, from the **More options** menu, select **Disable filter** to deactivate the filter, and see how the data has been returned to the insights.

### Change the Default Selections in the Filter Tile[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#change-the-default-selections-in-the-filter-tile "Permalink to this headline")

We might want to change the default selections for the filter tile, and we can do this in the Edit tab.

* From the dashboard’s **Edit** tab, select the filter tile.

* In the **Tile** tab, we can adjust settings, including the default selections. Check only the box for category **A**, and click **Save**.

* Navigate back to the **View** tab to see that the default filter has changed, but the user can still make new selections.

### Share a Filtered Dashboard via the URL[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#share-a-filtered-dashboard-via-the-url "Permalink to this headline")

Once you have filtered your dashboard, you may want to share the filtered view with other users. From 11.3, you can do it by generating a URL containing all the filter parameters and share this URL with others.

Important

The browser URL does not reflect the filters selection. If you share it, filters are not kept. It’s important to follow the procedure below.

* Go to the **View** tab.

* In the filter tile, click the **Copy URL in clipboard** button in the header. This action automatically computes the URL with the relevant filter parameters and copies it to your clipboard.

* Paste it anywhere to share it with the other stakeholders.

Note

The syntax of the generated URL is as follows:

§ ${DASHBOARD_ID}_{DASHBOARD_NAME}/view/${VIEW_ID}?${FILTER_QUERY}

The filter parameters change based on the filtering options you select in the filter tile header (**Include other values** or **Exclude other values**). For further information on the generated URL, see the documentation on Filters query parameter syntax.

### Export a Filtered Dashboard as PDF[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#export-a-filtered-dashboard-as-pdf "Permalink to this headline")

From 11.3, you can export the dashboard as a PDF with the filter parameters active in view mode. To do so, you can do it via the Dataiku interface or via the REST API.

**Export Using the Dataiku Interface**

* Go to the **View** tab.

* In the right panel, select the **Actions** tab then **Export**.

* Keep the default settings and click **Export Dashboard**.

The PDF is downloaded on your file system and includes the dashboard view that matches the filters selected.

**Export Using the REST API**

You can also use the REST API to export the dashboard using the `export` endpoint. In such case, the syntax of the POST URL is:

§ https://DSS_HOST:DSS_PORT/public/api/projects/{PROJECT_KEY}/dashboards/{DASHBOARD_KEY}/actions/export

Note

In the POST URL, `{DASHBOARD\_KEY}` is the key of the dashboard, not the slide. So if the dashboard URL is:

§ https://DSS_HOST:DSS_PORT/projects/QS_AI_CONSUMER_1/dashboards/oLeWRKL_purchase-patterns/view/GcHERXM

The POST URL should be:

§ https://DSS_HOST:DSS_PORT/public/api/projects/QS_AI_CONSUMER_1/dashboards/oLeWRKL/actions/export

The body of your request should look like that:

§ {

§ "paperSize": "A4",

§ "orientation": "LANDSCAPE",

§ "fileType": "PDF",

§ "width": 2505,

§ "height": 1771,

§ "filtersBySlide": ["item\_category:\"A\""]

§ }

### Understand Source Datasets for Filter Tiles[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#understand-source-datasets-for-filter-tiles "Permalink to this headline")

These are the basics, but two more concepts about filter tiles are important to understand.

The values in a filter tile come from a chosen column (or columns) in one **source dataset**.

* When this filter tile is activated, you’ll notice a filter icon in the top right corner of each insight.

* Hover over the filter icon to see the tooltip for each insight.

For the pivot table, the tooltip says **Data is filtered**, but, for the other two insights, the tooltip also notes a risk of inconsistency because the datasets are different.

The tooltip alerts us to the fact that the source dataset of the filter tile is different from the source dataset of the other insights. The source dataset for the filter tile and the pivot table is *transactions\_known*, while the source dataset for the bar chart and scatter plot is *transactions\_joined\_prepared*.

The filter tile, however, is applied to every insight on the dashboard slide. Is this a problem?

In this case, the values for *item\_category* for *transactions\_known* and *transactions\_joined\_prepared* happen to be the same (**A**, **B**, **C**, and **D**), but there is no guarantee that this will be true.

Imagine, for example, that the dataset *transactions\_joined\_prepared* had rows with a category **E** that were not found in *transactions\_known*. Category **E** would not appear as an option in the filter tile (which is based only on the values found in *transactions\_known*).

The insights on *transactions\_joined\_prepared* would not include any category **E** rows. They’d be filtered out without us explicitly knowing. Accordingly, we need to be particularly careful about using a filter tile on a dashboard slide with insights from different source datasets.

Let’s change the source dataset of the filter tile to be sure we understand the meaning of this message.

* In the dashboard’s **Edit** tab, return to the **Tile** tab of the filter tile.

* Click **Change Source Dataset > Other Dataset** .

* Choose *transactions\_joined\_prepared* as the source dataset and *item\_category* as the column.

* Save the change, and navigate back to the View tab.

Note how the display label on the filter tile has changed, and the messages on the Filter icon tooltip are reversed. The pivot table insight is now at risk of inconsistency!

### Use Sampling on Insights vs. Filter Tiles[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#use-sampling-on-insights-vs-filter-tiles "Permalink to this headline")

We know that the sampling method for a chart is independent from the sampling method for an insight produced from it. Filter tiles also have their own sampling method.

For example, to avoid too many overlapping points, we may prefer to use a sampling method on the scatter plot insight.

* Navigate to the **Edit** tab of the scatter plot insight.

Note

Clicking the arrow next to the insight title opens the insight.

* On the **Sampling & Engine** tab, change the **Sampling method** to **Random (approx. ratio)**. Click **Save and Refresh Sample**.

* **Save** the insight, and return to the dashboard’s **View** tab.

* In the dashboard’s **View** tab, hover over the **Sampled** tag to see more information about the sample size for this insight.

How does this sample interact with the filter tile?

* In the dashboard’s **View** tab, ensure that the filter tile is activated, and only values **A** are included for example.

* Observe the filter icon tooltips for all three insights.

* The scatter plot has a risk of inconsistency because the insight sample is different from the filter tile sample.

In this specific case, the risk may be manageable. We have a random sample in the insight, and the filter tile has removed any rows with an *item\_category* other than **A**.

As a demonstration though, we could use the same sampling strategy in the filter tile itself.

* Return to the tile menu of the filter tile in the dashboard’s **Edit** tab.

* In the **Sampling & Engine** tab, change the **Sampling method** to **Random (approx. ratio)**.

* Click **Apply**, save the result, and return to the dashboard’s **View** tab.

The filter tile now also has a sampled tag. The four categories, in this case, still happen to remain in the random sample.

* Check the filter icon tooltips once more.

* The tooltip on the pivot table still warns about a different dataset, but the tooltip on the bar chart notes the different sampling strategy.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/kb/exploration/dashboard-management.html#what-s-next "Permalink to this headline")

Congratulations! You’ve managed, edited and filtered a dashboard, that is ready to be shared with stakeholders.

The next step might be publishing the dashboard on a workspace.

Note

Consult the product documentation to learn more about dashboards, including insights.

To learn more about visualization with code, such as webapps and static insights, you might want to check out the Academy course on Visualization.
