# FAQ: Which activities in Dataiku require that a user be added to the allowed\_user\_groups local Unix group?[¶](https://knowledge.dataiku.com/latest/kb/governance/Which-activities-in-DSS-require-that-a-user-be-added-to-the.html#faq-which-activities-in-dataiku-require-that-a-user-be-added-to-the-allowed-user-groups-local-unix-group "Permalink to this headline")

When configuring the setup of the local code isolation capability of the User Isolation Framework (formerly known as Multi-User Security), you must fill in the `allowed\_user\_groups` settings with the list of UNIX groups to which your end users belong. Only users belonging to these groups will be allowed to use the local code impersonation mechanism.

If you have mixed types of users (data analysts, data scientists, etc.) and aren’t sure which types of Dataiku actions require membership in the `allowed\_user\_groups` local Unix group, below is a quick summary.

## DO NOT need to be in allowed\_user\_groups:[¶](https://knowledge.dataiku.com/latest/kb/governance/Which-activities-in-DSS-require-that-a-user-be-added-to-the.html#do-not-need-to-be-in-allowed-user-groups "Permalink to this headline")

* Users who only run visual recipes on DSS engine, visual recipes on SQL engine, or SQL recipes. For Prepare recipes, they do not use custom Python functions.

## DO need to be in allowed\_user\_groups:[¶](https://knowledge.dataiku.com/latest/kb/governance/Which-activities-in-DSS-require-that-a-user-be-added-to-the.html#do-need-to-be-in-allowed-user-groups "Permalink to this headline")

* Users who run any kind of local code (Python or R - be it in recipes, notebooks, webapps, scenarios, reports, etc.)

* Users who run visual ML

* Users who run any Spark-powered object (code recipe or notebook, or visual recipe using a Spark engine)

Note

The User Isolation Framework requires an Enterprise Edition license of Dataiku.

For detailed instructions on setting up local code isolation within the User Isolation Framework, visit our documentation.

## What’s Next?[¶](https://knowledge.dataiku.com/latest/kb/governance/Which-activities-in-DSS-require-that-a-user-be-added-to-the.html#whats-next "Permalink to this headline")

We see above that Dataiku features a set of mechanisms to isolate code which can be controlled by the user, so as to guarantee both traceability and inability for a hostile user to attack the dssuser (the DSS service account). However, the User Isolation Framework is not a single technology, but rather a set of capabilities that permit isolation depending on the context.

Learn more about the larger capabilities of UIF, prerequisites, and review reference architectures in the product documentation.
