# Build Your Security Model - DSS User Authentication[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-authentication.html#build-your-security-model-dss-user-authentication "Permalink to this headline")

Dataiku DSS (DSS) can use any of the following authentication methods to authenticate users on the platform:

* Local

+ This authentication method stores the user’s account and password locally on the DSS instance itself.

* LDAP

+ This method uses LDAP account/LDAP password or SSO directory services. For example, DSS can use a directory service such as Microsoft Active Directory (which stores information about your organization’s users and groups). This alleviates having to create new users manually.

+ This involves authenticating with a user account and password from your LDAP service, outside of DSS–for example, Microsoft Active Directory installed on a server on premise.

* Local (no auth, for SSO only).

+ Through this method, DSS uses Single Sign-On (SSO) to authenticate users through an external, SAML 2.0-compliant identity provider (IdP).

+ Users securely initiate a session in DSS without having to sign into DSS.

## Creating a Local User (Manually)[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-authentication.html#creating-a-local-user-manually "Permalink to this headline")

You can create users locally on the DSS node itself. The following example illustrates how a local user is created.

* From the **Administration** menu, navigate to the **Security** tab.

* Select **New User** to create a new **Data Scientist** profile.

* Assign the new user to a group.

For instructions on creating a group, visit Build Your Security Model - User Groups.

## Adding LDAP Users via LDAP Configuration[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-authentication.html#adding-ldap-users-via-ldap-configuration "Permalink to this headline")

DSS can authenticate users against an external LDAP directory in addition to its built-in user database. Most corporate directories provide LDAP authentication service, including Microsoft Active Directory. This enables integration of user and password management, as well as user rights assignment, with existing centrally-managed infrastructures.

### Gather LDAP Information[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-authentication.html#gather-ldap-information "Permalink to this headline")

Before configuring LDAP authentication, you’ll need to gather the following information about your directory service. For more information about these prerequisites, visit Configuring LDAP authentication.

* Basic connection information to your LDAP server (host name and port, credentials, connection security). To be obtained from your LDAP administrator.

* A filter (LDAP query template) defining the subset of your directory corresponding to users authorized to access this DSS instance.

* Optionally, another filter defining the groups to which a given user belongs, in order to further restrict login authorization (only members of these groups being authorized to access this DSS instance) or to define user rights within DSS.

### Connect to the LDAP Directory[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-authentication.html#connect-to-the-ldap-directory "Permalink to this headline")

To configure the connection to the LDAP directory, follow the instructions at Connecting to a LDAP directory.

#### Parameter guidelines:[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-authentication.html#parameter-guidelines "Permalink to this headline")

**Connection**

* Enter the **LDAP Server URL** from your LDAP administrator. The BASE part of the server URL specifies the search base DN (Distinguished Name) to use for user and group queries. This part is mandatory. A valid URL would be, for example: `ldap://ldap1.company.com/OU=France,DC=company,DC=com`

Note

For more information, visit Connection parameters.

**Users mapping**

* In **User filter**, enter a query placeholder. DSS replaces this placeholder by the username that the user enters on the DSS sign-in page.

* In **Display name attribute** and **Email attribute**, specify which attributes of the query correspond to the user’s display name and email in the directory.

* Select **Automatically import users** to automatically import users.

**Groups mapping**

Use this mapping to define which groups a user belongs to.

* In **Group name attribute**, specify an attribute for the group name.

* In **Authorized groups**, add the whitelist groups that are permitted to connect to DSS.

* Use **Profiles mapping** to define what profile a group is assigned to.

## Adding Local Users from an Azure Active Directory (AAD)[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-authentication.html#adding-local-users-from-an-azure-active-directory-aad "Permalink to this headline")

You can add local users from SAML identity providers, such as Microsoft Azure Active Directory (AAD).

Note

DSS supports AAD as a SAMLv2 IDP.

To import local users from an Azure Active Directory (AAD), you’ll need to use the Azure Active Directory plugin.

### Configuring Single Sign-On (SSO)[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/user-authentication.html#configuring-single-sign-on-sso "Permalink to this headline")

You can configure SSO so that your users don’t have to type their password when accessing DSS.

DSS supports the following SSO protocols:

* SAML v2 (recommended)

* OpenID Connect (OIDC)

* SPNEGO / Kerberos

SSO provides proof that the user performing a query is who they pretend to be. DSS validates this proof. To enforce security rules, DSS must also know who the user is and to which group(s) they belong.

Therefore, in SSO mode, DSS still needs to have a database of all users that are permitted to sign in, even if they don’t enter a password. This database can be one of the following types:

* Local user database, or

* LDAP (See Configuring LDAP authentication)

For SAML the following is needed:

* IdP Metadata (provided by SSO admin)

* Will likely need a callback url. For example: `https://dss.mycompany.corp/dip/api/saml-callback`

* SP Metadata (generate). If there’s no internal process, you can do this online. Will need at least entityID (from IdP Metadata) and Attribute Consume Service Endpoint (callback url). It is also not uncommon to get X.509 certs from the IdP Metadata.

* Login Attribute. Attribute in the assertion sent by IdP that contains the DSS login.

* Login Remapping Rules. Rules to map login attribute to user login. For example: `first.last@company.com → first.last via ([^@]\*)@mydomain.com -> $1`
