# Build Your Security Model - Global vs Per User Credentials[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/global-per-user-credentials.html#build-your-security-model-global-vs-per-user-credentials "Permalink to this headline")

Most SQL connections require credentials. When configuring a connection to a cloud object storage or SQL database, you can configure global or per-user credentials. This article discusses the advantages and disadvantages of each type of authentication mechanism.

## Global Credentials[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/global-per-user-credentials.html#global-credentials "Permalink to this headline")

Global credentials consists of using a dedicated service account to connect to and interact with the data inside the distant system. When configured, every call made to the distant system is performed with the dedicated service account.

There are several types of service accounts, including the following:

* Shared key or keypair for cloud storages.

* User/Password couple for SQL-like databases.

* Role to be assumed for AWS. To learn more, visit Using AWS AssumeRole with an S3 Connection to Persist Datasets.

### Advantages[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/global-per-user-credentials.html#advantages "Permalink to this headline")

* Only one authorization configuration to manage on the remote system.

* Password not shared with users.

+ To ensure the password is not shared with users, set the security parameter “Details readable by” to **None**. This parameter is found in the connection configuration.

* No multiple user accounts to manage. Less overhead, more security.

* Within Dataiku DSS (DSS), it is still possible to manage which user groups are allowed to use the connection.

* DSS includes a granular audit trail that logs all actions performed by the user in DSS.

### Disadvantages[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/global-per-user-credentials.html#disadvantages "Permalink to this headline")

* No granular audit trail on the remote system. However, in most cases, the Amazon S3 service keeps a track of the frontend user name in the principalId.

* No granular authorization. Every user who is allowed to interact through this connection is granted the same level of authorization.

## Per-User Credentials[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/global-per-user-credentials.html#per-user-credentials "Permalink to this headline")

For DSS connections that require credentials, you can configure the connection so that instead of having a global service credential, each user can enter personal credentials.

When per-user credentials is activated, every user will specify their own credentials to connect to the remote system. Each action performed on the database by the user will use the Dataiku user’s personal credentials.

To specify their credentials, the Dataiku user visits the **Profile and settings** menu and then finds **Connection credentials** by navigating to the **Credentials** tab.

There are several types of per-user credentials, including the following:

* Username and password combination. This applies to most database systems such as PostgreSQL and Oracle.

* Shared key or keypair for cloud object storage.

* Oauth2 credentials for more advanced authentication. Visit Connecting to data to find out more about specific connections and authenticating using Oauth2.

### Advantages[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/global-per-user-credentials.html#id1 "Permalink to this headline")

* Fine-grained access management on the remote system.

* Granular audit trail on the remote system.

* For Oauth authentication, the ability to rely on a centralized identity provider (IdP).

### Disadvantages[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/global-per-user-credentials.html#id2 "Permalink to this headline")

* Multiple accounts to manage.

* Passwords are known by users which presents security risks.

* Oauth2 mechanisms are complex to implement.

* Cannot test the connection during configuration.
