# Security Model Overview[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#security-model-overview "Permalink to this headline")

How do Dataiku DSS (DSS) users securely access the platform with the right permissions? In this article, we’ll provide a brief overview of security topics along with links to dive deeper into each topic. We’ll discuss how DSS identifies and authenticates users and relies on a groups-based model to provide users with the permissions they need to perform tasks such as access to data connections.

Note

Visit Configure Dataiku in the Knowledge Base or Security in the product documentation for more in-depth and related information.

## User Identity and User Authentication[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#user-identity-and-user-authentication "Permalink to this headline")

DSS relies on both user identity and user authentication: user identity to uniquely identify users of the platform and user authentication to prove that the user is who they claim to be.

### User Identity[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#user-identity "Permalink to this headline")

In general, user identity includes elements used to uniquely identify a user, such as:

* Login

* Name

* Email

* Profile

Note

Administrators can manage users by visiting the **Administration** menu and navigating to the **Security** tab as described in Building Your Security Model - User Authentication.

#### Local Database[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#local-database "Permalink to this headline")

When DSS identifies users through a local database, the DSS instance is the source of the information. The administrator manages and manually enters user information per instance directly in the **Security** tab of the **Administration** menu. This can happen via the user interface or through API calls. The data cannot be shared across instances.

#### LDAP[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#ldap "Permalink to this headline")

DSS can retrieve user information through Active Directory (AD) lightweight directory access protocol (LDAP).

When adding a new user through the **Security** tab on an instance, for example, the administrator visits the **Security** tab, selects to add a new user. and sets the user type to *LDAP*.

Dataiku signs in, checks the user in the external LDAP, and automatically creates the user in Dataiku.

### User Authentication[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#user-authentication "Permalink to this headline")

DSS can use a Local, LDAP, or Local (no auth, for SSO only) authentication method to authenticate users on the platform. For details, visit Building Your Security Model - DSS User Authentication.

For more information about SSO, visit Single Sign-On in the product documentation.

## Permissions Model[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#permissions-model "Permalink to this headline")

DSS uses a groups-based model to allow users to perform actions through it. Users can belong to an arbitrary number of groups. Groups can have one or several permissions.

There are two types of permissions: global group permissions (user groups) and per-resource group permissions.

By default, permissions are linked to two elements, user profiles and user groups.

### User Profiles[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#user-profiles "Permalink to this headline")

A User can have only one profile at a time. The profile is linked to the DSS license. To find out how many seats are available, you can visit **Administration** > **License**. A profile is a fixed authorization for a type of user. Profiles can be different between licenses.

Visit User profiles in the product documentation to find out more.

### Group Permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#group-permissions "Permalink to this headline")

A group is a configurable collection of users, such as administrators or data-team. Users can belong to an arbitrary number of groups for which their permissions become cumulative. The administrator assigns global permissions for each group. The administrator can choose to map permissions for a group locally or through LDAP.

### Per-Resource Permissions[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#per-resource-permissions "Permalink to this headline")

Once groups are configured, the administrator grants per-resource group permissions.

While groups have permissions at the instance level, the administrator can assign permissions to specific groups at the resource level.

Resources are elements where the administrator might want to manage security, including projects, code environments, managed clusters, containerized execution, and infrastructure elements of the Deployer.

Permissions are specific to a resource and differ between resource types. For example, whether or not a group can edit a project is configurable at the project level.

### Security Permissions for Data Connections[¶](https://knowledge.dataiku.com/latest/kb/setup-admin/configure/security/security-model.html#security-permissions-for-data-connections "Permalink to this headline")

Just like other resources, an administrator can configure security settings for data connections. Security settings for data connections include configuring which group(s) have access to the connection.

An administrator can also configure per-user credentials for data connections. When this is applied, users will need to update their credentials through their user profile.
