# CO2 Converter[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

## Convert electricity consumption into co2 emission based on the carbon intensity of the location and date. Also, get other features from Electricity Maps API.[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

|  |  |

| --- | --- |

| Version | 1.0.1 |

| Author | Dataiku (Romain Menini) |

| Released | 2022-08-01 |

| Last updated | 2022-10-10 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

## Description[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

This plugin allows you to :

* Convert electricity consumption into co2 emission based on the carbon intensity of the location and date

* Retrieve energy mix from a given location

* Retrieve the forecasted carbon intensity

## Data providers[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

This plugin is mainly based on data from Electricity Maps, a paid data provider. You’ll need to request an API token using the contact form. Before that, ensure the location you want to retrieve the carbon intensity from is covered on the Electricity Maps app.

You can also convert electricity consumption into co2 emissions for free by using RTE, but it only covers France.

## Setup[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

Once the plugin is installed from the store, if using Electricity Maps, to set your token, go to **Plugin > CO2 Converter > Settings > Electricity Maps API Configuration > + Add preset**.

## How to use[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

### Electricity to CO2 emissions conversion:[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

This component adds a recipe to the flow in which you need to specify a Date column and an electricity consumption column:

By default, the API provider is RTE. Once set up, the plugin automatically queries the API based on the date range from the input dataset, to avoid making too many requests. Also, due to electricity Maps API limitations, it creates chunks of 10 days for this data provider.

Since electricity maps requires a geopoint column, it allows multiple locations in the same input dataset. If you are using Electricity Maps, you will need to use a previously configured plugin preset before specifying the geopoint columns of your dataset. If you have longitude and latitude columns, you can create a geopoint using the dedicated data preparation processor.

Finally, run the plugin recipe to retrieve the closest carbon intensity from your location. The recipe outputs a dataset that appends 3 new columns to the input dataset:

* co2\_date\_time (closest date available from the API provider. It may be interesting to use metrics & checks  to check the difference between the requested and provided dates.)

* carbon\_intensity (gCO₂eq/kWh)

* co2\_emission (kgCO₂eq)

##[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

### Retrieve energy mix:[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

#### This component adds a recipe to the flow in which you need to specify an Electricity Maps API preset, a Date column, and a geopoint column. Then, you can select the columns from the Electricity Maps API you want to retrieve, among:[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

* Power Consumption Breakdown

* Power Production Breakdown

* Power Import Breakdown

* Power Export Breakdown

* Renewable percentage

* Fossil-free Percentage

* Power Consumption Total

* Power Production Total

* Power Import Total

Once you run the recipe, your initial dataset will be enriched with the selected columns according to the location and date time.

#### Retrieve forecasted carbon intensity:[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

#### This component adds a recipe to the flow in which you need to specify an Electricity Maps API preset and a geopoint column. Once you run the recipe, you’ll have the carbon\_intensity column containing the forecasted carbon intensity and the co2\_date\_time containing the date and time of the predicted values.[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

##### Install In DSS[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

To install the plugin, open the  Apps menu, click Plugins and search for co2 converter.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/co2-converter-2/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
