# Geocoder[¶](https://www.dataiku.com/product/plugins/geocoder/)

## This plugin provides recipes to perform forward and reverse geocoding from over 20 online providers[¶](https://www.dataiku.com/product/plugins/geocoder/)

Geocoding is the process of transforming an address into a set of coordinates that can be used on a map.    Reverse geocoding, on the other hand, is about converting coordinates to readable address.

This plugin provides recipes for both geocoding and reverse geocoding using online providers. It supports caching and batching options.

* **Forward geocoding providers**: Arcgis, Baidu, Bing**\***, CanadaPost, FreeGeoIP, Gaode, GeocodeFarm, Geonames, GeoOttawa, Gisgraphy, Google, HERE, IPInfo, Komoot, LocationIQ, MapBox, MapQuest**\***, Mapmind, OpenCage, OpenStreetMap, Tamu, TGOS, TomTom, USCensus**\***, What3Worls, Yahoo and Yandex

* **Reverse geocoding providers**: Arcgis, Baidu, Bing**\***, Gaode, GeocodeFarm, Gisgraphy, Google, HERE, Komoot, LocationIQ, MapBox, MapQuest, OpenCage, OpenStreetMap, USCensus, What3Worls and Yandex

**\***: batch geocoding is also available for these providers

## Plugin Information[¶](https://www.dataiku.com/product/plugins/geocoder/)

|  |  |

| --- | --- |

| Version | 1.2.0 |

| Author | Dataiku (Thomas Labadie) |

| Released | 2018-03-05 |

| Last updated | 2021-06-16 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

## How To Use[¶](https://www.dataiku.com/product/plugins/geocoder/)

You need to install the plugin and then use the newly installed recipes.    Some API providers might need an API key to use their service. Please refer to each provider’s website for further informations on their usage conditions and rate limits.

You can customise how the caching is done in the plugin settings. Multiple options are available:

* Cache **location** (Dataiku data directory by default)

* Cache **size per geocoding type** (1000MB = 1GB by default)

* Cache **eviction policy per geocoding type** (Least Recently Stored by default)

Each recipe lets you also choose:

* A **prefix** for the output columns.

* To enable or disable **cache and/or batch** (if available).

You can use this recipe multiple times in a row using different providers, for exemple in case the previous providers failed on some inputs. It will only try to recompute rows which outputs are not already filled.

## Which Provider Should I Use?[¶](https://www.dataiku.com/product/plugins/geocoder/)

Confused between all theses providers? You should choose one that is optimal for the region of the world you want to geocode on.

Free providers usually have quite small limits, so you should consider upgrading to a paid plan when you go into production.

| Provider | Optimal | Usage Policy |

| --- | --- | --- |

| ArcGIS | World |  |

| Baidu | China | API key |

| Bing | World | API key |

| CanadaPost | Canada | API key |

| FreeGeoIP | World |  |

| Gaode | China | API key |

| Geocoder.ca (Geolytica) | CA & US | Rate Limit |

| GeocodeFarm | World | Policy |

| GeoNames | World | Username |

| GeoOttawa | Ottawa |  |

| Gisgraphy | World | API key |

| Google | World | Rate Limit, Policy |

| HERE | World | API key |

| IPInfo | World | Rate Limit, Plans |

| Komoot (OSM powered) | World |  |

| LocationIQ | World | API Key |

| Mapbox | World | API key |

| MapQuest | World | API key |

| MaxMind | World |  |

| OpenCage | World | API key |

| OpenStreetMap | World | Policy |

| Tamu | US | API key |

| TGOS | Taiwan |  |

| TomTom | World | API key |

| USCensus | US |  |

| What3Words | World | API key |

| Yahoo | World |  |

| Yandex | Russia |  |

## Acknowledgements[¶](https://www.dataiku.com/product/plugins/geocoder/)

This plugin uses two amazing Python libraries to provide you with these features:

* Geocoder for the geocoding

* Diskcache for the caching

### Install In DSS[¶](https://www.dataiku.com/product/plugins/geocoder/)

To install the plugin, open the  Apps menu, click Plugins and search for Geocoder.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/geocoder/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
