# Google Calendar[¶](https://www.dataiku.com/product/plugins/google-calendar/)

## Retrieve all the events from your Google Calendar, or from any resources you have read access to[¶](https://www.dataiku.com/product/plugins/google-calendar/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/google-calendar/)

|  |  |

| --- | --- |

| Version | 1.0.1 |

| Author | Dataiku (Alex Bourret) |

| Released | 2021-04 |

| Last updated | 2022-12-20 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

With this plugin, you will be able to retrieve events from your Google Calendar account

## How to set up[¶](https://www.dataiku.com/product/plugins/google-calendar/)

If you are a Dataiku and Google Cloud admin user, follow these configuration steps right after you install the plugin. If you are not an admin, you can forward this to your admin and scroll down to the **How to use**section.

### 1. Create an API key in Google Calendar[¶](https://www.dataiku.com/product/plugins/google-calendar/)

Activate Google Calendar API

### 2. Create and configure a Single Sign On preset in Dataiku[¶](https://www.dataiku.com/product/plugins/google-calendar/)

In Dataiku, go to **Applications > Plugins > Google Calendar > Google Single Sign On**, create and name a new preset and complete the connection details gathered at step 3.

## How to use[¶](https://www.dataiku.com/product/plugins/google-calendar/)

Before the plugin can be used for a given Dataiku user, it has to be enabled with its own profile. To do so, go to the **Dataiku profile page > Credential**, and click on the edit icon corresponding to the google-calendar preset. This will redirect the user to the Google Authentication page where they can allow Dataiku to access the data from their Calendar account.

This plugin has two components: a custom dataset and a recipe.

In a project flow, you can add a dataset by clicking on **+Dataset > Google Calendar**. Then, select the authentication preset created and activated in the previous steps. Specify the id of the calendar you want to consult. By default, it will be “primary”. You can narrow your Calendar Events search by adding a start and/or end date.

In some instance, you may want to retrieve the calendar of several resources, several time ranges, or a combination of both. To do so, create a dataset containing the combinations you want to retrieve, says a list of calendar ids of several resources.

Then use it as an input to the Google Calendar recipe: in your project flow, click **+Recipe > Google Calendar**.

Use the list of calendar id as input and create an output dataset. Pick a column name corresponding to each condition you want to search (any combination of *calendar ids*, *from dates* and *end dates*).

Next, run the recipe and the calendars corresponding to each line of the input dataset will be retrieved in the output dataset.

## Obtain Google Calendar IDs[¶](https://www.dataiku.com/product/plugins/google-calendar/)

In many places, additional resources, such as room booking… can be obtained from your Google Calendar account. You can retrieve events related to them, using the plugin’s dataset or custom recipe. To do so, access the settings of the calendar you want access to.

Then, scroll down to the **Integrate Calendar** section and copy the calendar ID. Then use this ID directly in the *calendar ID* section of the dataset, or in a calendar ID column which of a dataset you then feed to the plugin’s recipe.

### Install In DSS[¶](https://www.dataiku.com/product/plugins/google-calendar/)

To install the plugin, open the  Apps menu, click Plugins and search for Googe Calendar.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/google-calendar/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
