# KML format[¶](https://www.dataiku.com/product/plugins/kml-format/)

## This plugin adds KML and KMZ geospatial formats to DSS[¶](https://www.dataiku.com/product/plugins/kml-format/)

## Plugin Information[¶](https://www.dataiku.com/product/plugins/kml-format/)

|  |  |

| --- | --- |

| Version | 0.1.0 |

| Author | Dataiku |

| Released | 2020-11 |

| Last updated | 2020-11 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

KML is a file format used to display geographic data in an Earth browser such as Google Earth. KML uses a tag-based structure with nested elements and attributes and is based on the XML standard. (See official definition of KML)

KMZ is a zip archive containing a *doc.kml* main file in the KML format and other arbitrary files. (See additional information on Google developers website about KMZ)

This plugin enables reading both formats in DSS and creating datasets from KML or KMZ.

## Features[¶](https://www.dataiku.com/product/plugins/kml-format/)

In both cases (KML or KMZ), this plugin reads a KML and convert it as a DSS dataset. A KML file contains a nested structure (XML-like) of tags. For each geospatial object contained in a <Placemark> tag, a row of a DSS dataset is created. There are three expected types for the geospatial objects: Point, LineString and Polygons. Note that, any geospatial element in a DSS dataset is by default typed as **geopoint**, enabling automatic processing and visualisation related to geospatial data.

## How To Use[¶](https://www.dataiku.com/product/plugins/kml-format/)

Create a dataset from a file in DSS,

Choose a KML or a KMZ file for dataset creation in DSS,

Select **KML/KMZ** as the input format of your dataset, the plugin will select the appropriate processing of the input file based on its extension to extract tags.

Given the output dataset, a chart can be created choosing the geometry chart type, information contained in the KML/KMZ will be displayed as usual in DSS,

###[¶](https://www.dataiku.com/product/plugins/kml-format/)

### Import KMZ file as DSS dataset[¶](https://www.dataiku.com/product/plugins/kml-format/)

In the case where a KMZ is uploaded instead of a KML, the DSS plugin will apply a KML processing on the *doc.kml* file that must be contained in the KMZ archive.

Additional instructions are available in our Github repository

#### Install In DSS[¶](https://www.dataiku.com/product/plugins/kml-format/)

To install the plugin, open the  Apps menu, click Plugins and search for KML.

Alternatively, you can download a zipped version here.
