# Snowflake stages export[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

## This plugin lets you export a DSS Snowflake dataset to a Snowflake stage.[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

###[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

|  |  |

| --- | --- |

| Version | 1.0.0 |

| Author | Dataiku (Nicolas Monchy, Allan Francani) |

| Released | 2021-06 |

| Last updated | 2021-06 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

Snowflake stages are Snowflake objects pointing to a storage location. They are used to load and unload data from Snowflake, without passing credentials in the copy command.

This plugin is about unloading data from a DSS Snowflake dataset to a Snowflake stage.

## Prerequisites[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

To use this plugin, the Snowflake stages need to be already created. This also applies to custom file formats if you wish to use any.

## How to use[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

Let’s assume that you have installed this plugin and that you have a Dataiku DSS project with Snowflake datasets.

### Export a dataset from the flow[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

###[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

The name of the output file(s) is prefixed with the name of the dataset you exported.

### Export a dataset from a scenario[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

ℹ️ If you have multiple Snowflake connections in your project, make sure to select a dataset, a stage and a file format from the same connection.

## Customize the output[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

### Output path[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

By default, the output files are written to */<project key>/*This path will be replaced by any value that you enter. If you want to write the output files at the root of the stage, simply enter */*

### File format[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

Snowflake lets you create custom file formats. You may ask your Snowflake administrator to create new ones if needed. By default, the plugin will use the default file format of your connection.

Additional instructions are available in our Github repository.

#### Install In DSS[¶](https://www.dataiku.com/product/plugins/snowflake-stages-export/)

To install the plugin, fetch it from Github.
