# Tableau Hyper Export[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

## Export datasets to Tableau using the Hyper format.[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

Tableau is one of the leading data visualisation tools and a Dataiku partner.

This plugin enables seamless interaction between Tableau Hyper format and DSS datasets. It also provides capability to upload datasets to Tableau Server or Tableau Online.

This plugin comes with the following features:

* Import a Hyper file in Dataiku as a standard dataset

* Export a DSS standard dataset to a Hyper file for immediate import in Tableau Desktop

* Directly upload a dataset to Tableau Server with the Hyper format

* Make credentials to Tableau Server available to all DSS users on instance using a Plugin Preset

This plugin uses the regular export infrastructure of DSS, meaning you can export to Tableau:

* Datasets

* Prepared data

* Results of SQL notebooks

* Pandas dataframes from Jupyter

* Dataset schemas

* Machine learning results

## Plugin Information[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

|  |  |

| --- | --- |

| Version | 0.1.5 |

| Author | Dataiku |

| Released | 2020/05/13 |

| Last updated | 2021/12/06 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

## Requirements[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

This plugin requires DSS 6.X or higher. The installation setup for this plugin follows the standard Dataiku code environment creation procedure. This plugin requires the Python modules Tableau Server Client and Tableau Hyper API that will be installed automatically through Pip. Note that the Tableau Hyper API is compatible with Python 3.6 or Python 3.7 and not with older versions of Python.

Requirements and packages version:

* tableauhyperapi==0.0.13287

* tableauserverclient==0.15.0

## Upgrading this plugin[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

The new version of this plugin is only compatible with Python 3.6 and Python 3.7. If an oldest version of this plugin has been installed in a Python 2.7 or Python 3.5 code environment, make sure to create a new code environment associated with the plugin through the plugin interface, or destroy the pre-existing associated code environment in `Administration > Code Envs` and create a new one with a compatible Python version through the plugin interface.

After updating the code environment, the plugin can be used in all pre-existing flows built with previous version of the Tableau Hyper plugin.

## How To Use[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

The plugin provides two exporters, available in the standard “Export” dialog of DSS, a file format component allowing creation of Dataiku dataset from Hyper files, and a plugin preset enabling Tableau Server credentials to be accessible to all users on the Dataiku instance of your organisation.

### Export DSS dataset as Tableau Hyper file[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

Export your DSS dataset directly from your flow,

Choose the Tableau Hyper file format,

Download the Tableau Hyper file locally,

Open it in Tableau Desktop,

This plugin performs automatic type conversion on values between DSS storage types and Tableau Hyper TypeTags. The processing that will be applied to each value is selected based on the storage type in DSS. Under column names in DSS, there are two different indications on types. The grey upper one indicates the storage type and will be the one used for value and type conversion. The blue one is the inferred type and enables recommendations of appropriate processing actions in DSS. Therefore, if a geocolumn is to be exported as such in Tableau Hyper from DSS, make sure that the grey storage type is *geopoint* otherwise it might appear as a string in Tableau Hyper. (Same for the date storage type)

### Upload DSS dataset as Tableau Hyper file to Tableau Server or Tableau Online[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

Export your DSS dataset to Tableau Server directly from the flow (**The generated Table.Schema couple will be Extract.Extract**),

Access it on Tableau Server or Tableau Online,

Interact with your data and create data visualisation in the cloud,

### Import a Tableau Hyper file as a DSS dataset[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

A good practice to create a DSS dataset from a Tableau Hyper file is to first create a managed folder in the flow that will contain the `.hyper` files then  create a DSS dataset from the Tableau Hyper files,

(More information on Managed Folders can be found here: https://doc.dataiku.com/dss/latest/connecting/managed\_folders.html , a managed folder can be created from the flow: **+Dataset > Folder**)

Choose the target table and schema to extract from your Tableau Hyper file and create a dataset (**Note that the specified couple of (table, schema) have to be present in the file otherwise an error will be thrown**),

The plugin will take care of data conversion between Tableau Hyper and DSS storage types. The Tableau Hyper column types can be found here: https://help.tableau.com/current/api/hyper\_api/en-us/reference/py/tableauhyperapi.html#tableauhyperapi.TypeTag, automatic data conversion is performed for booleans, string, numbers, geography and dates. The following Tableau Hyper TypeTag do not have an equivalent in DSS: BYTES, INTERVAL, JSON, OID, TIME, TIMESTAMP\_TZ, VARCHAR. However, custom additional processing can be made in DSS in order to extract some semantics from those TypeTags.

### Using plugin preset to make credentials accessible to every user on instance[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

Give access to Tableau Server to any DSS users by setting the credentials for multiple users through a plugin preset,

Additional instructions are available in our Github repository

#### Install In DSS[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

To install the plugin, open the  Apps menu, click Plugins and search for Tableau Hyper Export.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/tableau-hyper-export/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
