# Importing tables as datasets[¶](https://developer.dataiku.com/latest/concepts-and-examples/tables-import.html#importing-tables-as-datasets "Permalink to this heading")

The “import tables as datasets” feature is available through the API, both for Hive and SQL tables

## Importing SQL tables[¶](https://developer.dataiku.com/latest/concepts-and-examples/tables-import.html#importing-sql-tables "Permalink to this heading")

§ project = client.get\_project("MYPROJECT")

§ import\_definition = project.init\_tables\_import()

§ import\_definition.add\_sql\_table("my\_sql\_connection", "schema\_of\_the\_table", "name\_of\_the\_table")

§ prepared\_import = import\_definition.prepare()

§ future = prepared\_import.execute()

§ import\_result = future.wait\_for\_result()

## Importing Hive tables[¶](https://developer.dataiku.com/latest/concepts-and-examples/tables-import.html#importing-hive-tables "Permalink to this heading")

§ project = client.get\_project("MYPROJECT")

§ import\_definition = project.init\_tables\_import()

§ import\_definition.add\_hive\_table("hive\_database", "hive\_table\_name")

§ prepared\_import = import\_definition.prepare()

§ future = prepared\_import.execute()

§ import\_result = future.wait\_for\_result()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/tables-import.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.project.TablesImportDefinition`(...) | Temporary structure holding the list of tables to import |

| `dataikuapi.dss.project.TablesPreparedImport`(...) | Result of preparing a tables import. |
