# Authentication[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#authentication "Permalink to this heading")

## Introduction[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#introduction "Permalink to this heading")

From any Python code, it is possible to retrieve information about the user or API key currently running this code.

This can be used:

* From code running within a recipe or notebook, for the code to know who is running said code

* From code running with a plugin recipe, for the code to know who is running said code

* From code running outside of DSS, simply to retrieve details of the current API key

Furthermore, the API provides the ability, from a set of HTTP headers, to identify the user represented by these headers. This can be used in the backend of a webapp (either Bokeh, Dash or Flask), in order to securely identify which user is currently browsing the webapp.

## Code samples[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#code-samples "Permalink to this heading")

### Getting your own login information[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#getting-your-own-login-information "Permalink to this heading")

§ auth\_info = client.get\_auth\_info()

§ # auth\_info is a dict which contains at least a "authIdentifier" field, which is the login for a user

§ print("User running this code is %s" % auth\_info["authIdentifier"])

### Authenticating calls made from a webapp[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#authenticating-calls-made-from-a-webapp "Permalink to this heading")

Please see Webapps and security.

### Impersonating another user[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#impersonating-another-user "Permalink to this heading")

As a DSS administrator, it can be useful to be able to perform API calls on behalf of another user.

§ user = client.get\_user("the\_user\_to\_impersonate")

§ client\_as\_user = user.get\_client\_as()

§ # All calls done using `client\_as\_user` will appear as being performed by `the\_user\_to\_impersonate` and will inherit

§ # its permissions

### Modifying your own user properties[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#modifying-your-own-user-properties "Permalink to this heading")

As a user (not an administrator), you can modify some of your own settings:

* User properties

* User secrets (see below)

* Per-user-credentials (see below)

§ my\_user = client.get\_own\_user()

§ settings = my\_user.get\_settings()

§ settings.user\_properties["myprop"] = "myvalue"

§ settings.save()

### Modifying your own user secrets[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#modifying-your-own-user-secrets "Permalink to this heading")

§ my\_user = client.get\_own\_user()

§ settings = my\_user.get\_settings()

§ settings.add\_secret("secretname", "secretvalue")

§ settings.save()

### Entering a per-user-credential for a connection, for yourself[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#entering-a-per-user-credential-for-a-connection-for-yourself "Permalink to this heading")

To do it for other users, Users and groups.

§ my\_user = client.get\_own\_user()

§ settings = my\_user.get\_settings()

§ settings.set\_basic\_connection\_credential("myconnection", "username", "password")

§ settings.save()

### Entering a per-user-credential for a plugin preset, for yourself[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#entering-a-per-user-credential-for-a-plugin-preset-for-yourself "Permalink to this heading")

To do it for other users, see Users and groups.

§ my\_user = client.get\_own\_user()

§ settings = my\_user.get\_settings()

§ settings.set\_basic\_plugin\_credential("myplugin", "my\_paramset\_id", "mypreset\_id", "param\_name", "username", "password")

§ settings.save()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/authinfo.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dssclient.DSSClient.get\_auth\_info`([...]) | Returns various information about the user currently authenticated using this instance of the API client. |

| `dataikuapi.dssclient.DSSClient.get\_auth\_info\_from\_browser\_headers`(...) | Returns various information about the DSS user authenticated by the dictionary of HTTP headers provided in headers\_dict. |
