# The main FMClient class[¶](https://developer.dataiku.com/latest/concepts-and-examples/fleetmanager/fmclient.html#the-main-fmclient-class "Permalink to this heading")

The REST API Python client makes it easy to write client programs for the Fleet Manager REST API in Python. The REST API Python client is in the `dataikuapi` Python package.

The client is the entrypoint for many of the capabilities listed in this chapter.

## Creating a Fleet Manager client[¶](https://developer.dataiku.com/latest/concepts-and-examples/fleetmanager/fmclient.html#creating-a-fleet-manager-client "Permalink to this heading")

To work with the API, a connection needs to be established with Fleet Manager, by creating an `FMClient` object. Once the connection is established, the `FMClient` object serves as the entry point to the other calls.

Depending on your cloud provider, you will have to create the dedicated `FMClient`:

* a `FMClientAWS` for Amazon Web Services

* a `FMClientAzure` for Microsoft Azure

* a `FMClientGCP` for Google Cloud Platform

To connect you will need to provide the URL of your Fleet Manager server, and a key identifier and secret

§ import dataikuapi

§ key\_id = "<my key id>"

§ key\_secret = "<my key secret>"

§ client = dataikuapi.FMClientAWS("https://localhost", key\_id, key\_secret)

§ client = dataikuapi.FMClientAzure("https://localhost", key\_id, key\_secret)

§ client = dataikuapi.FMClientGCP("https://localhost", key\_id, key\_secret)

§ # client is now a FMClient and can perform all authorized actions.

§ # For example, list the DSS instances in the fleet for which you have access

§ client.list\_instances()

## Reference API doc[¶](https://developer.dataiku.com/latest/concepts-and-examples/fleetmanager/fmclient.html#reference-api-doc "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.fmclient.FMClient`(host, ...[, ...]) |  |

| `dataikuapi.fmclient.FMClientAWS`(host, ...[, ...]) |  |

| `dataikuapi.fmclient.FMClientAzure`(host, ...) |  |

| `dataikuapi.fmclient.FMClientGCP`(host, ...[, ...]) |  |
