# Govern Roles and Permissions Handler[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-admin-roles-permissions-handler.html#govern-roles-and-permissions-handler "Permalink to this heading")

The Roles and Permissions Handler is used to manage roles, role assignments and permissions.

## Add a rule to assign a role to a new user[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-admin-roles-permissions-handler.html#add-a-rule-to-assign-a-role-to-a-new-user "Permalink to this heading")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # get the role and permissions editor

§ rp\_editor = client.get\_roles\_permissions\_handler()

§ # retrieve the role assignements for the Business initiative blueprint

§ bi\_ra = rp\_editor.get\_role\_assignments('bp.system.business\_initiative')

§ # get the definition

§ bi\_ra\_def = bi\_ra.get\_definition()

§ # add a rule to assign the new user to the project manager role

§ project\_manager\_def = bi\_ra\_def.get\_raw()['roleAssignmentsRules'].get('ro.project\_manager', [])

§ project\_manager\_def.append({

§ "criteria": [],

§ "userContainers": [{"type": "user", "login": "new\_user"}]

§ })

§ bi\_ra\_def.get\_raw()['roleAssignmentsRules']['ro.project\_manager'] = project\_manager\_def

§ bi\_ra\_def.save()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-admin-roles-permissions-handler.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminRolesPermissionsHandler`(client) | Handle to edit the roles and permissions Do not create this directly, use `get\_roles\_permissions\_handler()` |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminRoleListItem`(...) | An item in a list of roles. |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminRole`(...) | A handle to interact with the roles of the instance as an admin. |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminRoleDefinition`(...) | The definition of a specific role. |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminBlueprintRoleAssignmentsListItem`(...) | An item in a list of blueprint role assignments. |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminBlueprintRoleAssignments`(...) | A handle to interact with the blueprint role assignments for a specific blueprint Do not create this directly, use `get\_role\_assignments()` |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminBlueprintRoleAssignmentsDefinition`(...) | The role assignments for a specific blueprint. |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminBlueprintPermissionsListItem`(...) | An item in a list of blueprint permissions. |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminBlueprintPermissions`(...) | A handle to interact with blueprint permissions for a specific blueprint Do not create this directly, use `get\_blueprint\_permissions()` |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminBlueprintPermissionsDefinition`(...) | The permissions for a specific blueprint. |

| `dataikuapi.govern.admin\_roles\_permissions\_handler.GovernAdminDefaultPermissionsDefinition`(...) | The default permissions of the instance Do not create this directly, use `get\_default\_permissions\_definition()` |
