# Govern Artifacts[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-artifacts.html#govern-artifacts "Permalink to this heading")

Artifacts are all items in Dataiku Govern. Note: to learn more about them, go to the Dataiku Govern definitions page.

## List all artifact sign-offs[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-artifacts.html#list-all-artifact-sign-offs "Permalink to this heading")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # retrieve a specific artifact by its ID

§ artifact = client.get\_artifact('ar.1773')

§ # list all its sign-offs

§ signoffs = artifact.list\_signoffs()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-artifacts.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.govern.artifact.GovernArtifact`(...) | A handle to interact with an artifact on the Govern instance. |

| `dataikuapi.govern.artifact.GovernArtifactDefinition`(...) | The definition of an artifact. |

| `dataikuapi.govern.artifact.GovernArtifactSignoffListItem`(...) | An item in a list of sign-offs. |

| `dataikuapi.govern.artifact.GovernArtifactSignoff`(...) | Handle to interact with the sign-off of a specific workflow step. |

| `dataikuapi.govern.artifact.GovernArtifactSignoffCycleDefinition`(...) | The definition of a sign-off cycle. |

| `dataikuapi.govern.artifact.GovernArtifactSignoffCycleDetails`(...) | The details of a sign-off cycle. |
