# Download from a Dataiku DSS Webapp[¶](https://developer.dataiku.com/latest/tutorials/webapps/standard/download-file-kb/index.html#download-from-a-dataiku-dss-webapp "Permalink to this heading")

When building a webapp in Dataiku DSS, you may want to allow users to download a file from a managed folder. Here are steps to build an HTML button, which will allow webapp users to download files stored in a managed folder.

## Basic Download[¶](https://developer.dataiku.com/latest/tutorials/webapps/standard/download-file-kb/index.html#basic-download "Permalink to this heading")

Here’s how you can download a file from a managed folder by clicking on a button in a webapp.

In the Python part of the webapp, define an endpoint like:

§ import dataiku

§ from flask import request

§ from flask import send\_file

§ import io

§ @app.route('/downloadFile')

§ def first\_call():

§ filename = request.args.get('filename')

§ stream = dataiku.Folder('FOLDER\_ID').get\_download\_stream(filename)

§ with stream:

§ return send\_file(

§ io.BytesIO(stream.read()),

§ as\_attachment=True,

§ attachment\_filename=filename)

Then in the Javascript section, you’d need a function like:

§ window.download = function(){

§ window.location.href = getWebAppBackendUrl('/downloadFile?filename=test.txt');

§ }

Finally, in the HTML you can add a button to trigger that JS function:

§ <button onclick="download()">Download</button>

## What’s Next?[¶](https://developer.dataiku.com/latest/tutorials/webapps/standard/download-file-kb/index.html#whats-next "Permalink to this heading")

To learn more about webapps in Dataiku DSS, visit the Dataiku Academy for tutorials and examples.
