# Load and re-use a TensorFlow Hub model[¶](https://developer.dataiku.com/latest/tutorials/machine-learning/code-env-resources/tf-resources/index.html#load-and-re-use-a-tensorflow-hub-model "Permalink to this heading")

Pre-requisites

* Dataiku >= 10.0.0.

* A Code Environment with the following packages:

§ tensorflow==2.8.0

§ tensorflow-estimator==2.6.0

§ tensorflow-hub==0.12.0

§ protobuf>=3.20,<3.21

§ requests==2.28.1

§ Pillow==9.3.0

Machine learning use cases can involve a lot of input data and compute-heavy thus expensive model training. Instead, you might want to reuse artifacts for common tasks like pre-processing images or text for model training. You can load *pre-trained models* from remote repositories and embed them in your code.

In this tutorial, you will use Dataiku’s Code Environment resources feature to download and save a pre-trained image classification model from the TensorFlow Hub. You will then reuse it to classify a picture downloaded from the Internet.

## Loading the pre-trained model[¶](https://developer.dataiku.com/latest/tutorials/machine-learning/code-env-resources/tf-resources/index.html#loading-the-pre-trained-model "Permalink to this heading")

The first step is to download the required assets for your pre-trained model. To do so, in the *Resources* screen of your Code Environment, input the following **initialization script** then click on *Update*:

§ ## Base imports

§ from dataiku.code\_env\_resources import clear\_all\_env\_vars

§ from dataiku.code\_env\_resources import set\_env\_path

§ from dataiku.code\_env\_resources import set\_env\_var

§ # Clears all environment variables defined by previously run script

§ clear\_all\_env\_vars()

§ ## TensorFlow

§ # Set TensorFlow cache directory

§ set\_env\_path("TFHUB\_CACHE\_DIR", "tensorflow")

§ # Import TensorFlow Hub

§ import tensorflow\_hub as hub

§ # Download pretrained model: automatically managed by Tensorflow,

§ # does not download anything if model is already in TFHUB\_CACHE\_DIR

§ model\_hub\_url = "https://tfhub.dev/google/tf2-preview/mobilenet\_v2/classification/4"

§ hub.KerasLayer(model\_hub\_url)

This script will retrieve a MobileNet v2 model from Tensorflow Hub and store it on the Dataiku Instance.

Note that it will only need to run once, after that all users allowed to use the Code Environment will be able to leverage the pre-trained model with re-downloading it again.

## Using the pre-trained model for inference[¶](https://developer.dataiku.com/latest/tutorials/machine-learning/code-env-resources/tf-resources/index.html#using-the-pre-trained-model-for-inference "Permalink to this heading")

You can now re-use this pre-trained model in your Dataiku Project’s Python Recipe or notebook. Here is an example adapted from a tutorial on the Tensorflow website that downloads a sample image and predicts its class from the ImageNet labels.

§ import tensorflow as tf

§ import tensorflow\_hub as hub

§ import numpy as np

§ from PIL import Image

§ model\_name = "https://tfhub.dev/google/tf2-preview/mobilenet\_v2/classification/4"

§ # Load the pre-trained model

§ img\_shape = (224, 224)

§ classifier = tf.keras.Sequential([

§ hub.KerasLayer(model\_name, input\_shape=img\_shape+(3,))

§ ])

§ # Download image and compute prediction

§ img\_url = "https://upload.wikimedia.org/wikipedia/commons/b/b0/Bengal\_tiger\_%28Panthera\_tigris\_tigris%29\_female\_3\_crop.jpg"

§ img = tf.keras.utils.get\_file('image.jpg', img\_url)

§ img = Image.open(img).resize(IMAGE\_SHAPE)

§ img = np.array(img)/255.0

§ result = classifier.predict(img[np.newaxis, ...])

§ # Map the prediction result to the corresponding class label

§ labels\_url = "https://storage.googleapis.com/download.tensorflow.org/data/ImageNetLabels.txt"

§ predicted\_class = tf.math.argmax(result[0], axis=-1)

§ labels\_path = tf.keras.utils.get\_file('ImageNetLabels.txt', labels\_url)

§ imagenet\_labels = np.array(open(labels\_path).read().splitlines())

§ predicted\_class\_name = imagenet\_labels[predicted\_class]

§ print(f"Predicted class name: {predicted\_class\_name}")

Running this code should give you the following output:

§ Predicted class name: tiger

## Wrapping up[¶](https://developer.dataiku.com/latest/tutorials/machine-learning/code-env-resources/tf-resources/index.html#wrapping-up "Permalink to this heading")

Your pre-trained model is now operational! From there you can easily reuse it, e.g. to directly classify other images stored in a Managed Folder or to fine-tune it for a more specific task.
