# Trend/seasonal decomposition[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#trend-seasonal-decomposition "Permalink to this headline")

Trend/seasonal decomposition is useful to understand, clean, and leverage your time series data. Not only is it necessary to retrieve seasonally-adjusted data, but it is also relevant for anomaly detection. This recipe decomposes the numerical columns of your time series into three components: trend, seasonality and residuals. The recipe relies on STL, seasonal and trend decomposition using Loess. For more information, see Statsmodel’s documentation.

Note

The decomposition recipe only supports Python 3.6.

* Input Data

* Settings

* Related pages

## Input Data[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#input-data "Permalink to this headline")

Data that consists of equispaced *n*-dimensional time series in wide or long format.

## Settings[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#settings "Permalink to this headline")

### Input parameters[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#input-parameters "Permalink to this headline")

#### Time column[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#time-column "Permalink to this headline")

Column with parsed dates and no missing values:

* To parse dates, you can use a Prepare recipe.

* To fill missing values, you can use the Time Series Preparation Resampling recipe.

#### Frequency[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#frequency "Permalink to this headline")

Frequency of the time column, from year to minute:

* For minute and hour frequency, you can select the number of minutes or hours.

* For week frequency, you can select the end-of-week day.

#### Season length[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#season-length "Permalink to this headline")

Length of the seasonal **period** in selected frequency unit.

* For example, season length is 7 for daily data with a weekly seasonality

* Season length is 4 for a 6H frequency with a daily seasonality

#### Target column(s)[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#target-column-s "Permalink to this headline")

Time series columns that you want to decompose. It must be numeric (*int* or *float*). You can select one or multiple columns.

#### Long format checkbox[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#long-format-checkbox "Permalink to this headline")

Indicator that the input data is in the long format. See Long format.

#### Time series identifiers[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#time-series-identifiers "Permalink to this headline")

The names of the columns that contain identifiers for the time series when the input data is in the long format. This parameter is available when you enable the “Long format” checkbox. You can select one or multiple columns.

### Decomposition parameters[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#decomposition-parameters "Permalink to this headline")

#### Model type[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#model-type "Permalink to this headline")

The decomposition model of your time series. It may be :

* **Additive** : Time series = trend + seasonality + residuals

* **Multiplicative** : Time series = trend × seasonality × residuals

If the magnitude of the seasonality varies with the mean of the time series, then the series is multiplicative. Otherwise, the series is additive.

Note

* A multiplicative model is only compatible with positive numerical values.

* For multiplicative STL, the recipe first takes the logarithms of the data, then computes an additive decomposition and finally back-transforms the data.

### Advanced parameters[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#advanced-parameters "Permalink to this headline")

#### Seasonal smoother[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#seasonal-smoother "Permalink to this headline")

The window size used to estimate the seasonal component in STL decompositions. It must be an odd integer greater than 7. It controls how rapidly the seasonal component can change.

#### Robust to outliers[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#robust-to-outliers "Permalink to this headline")

If selected, the estimation will re-weight data, allowing the model to tolerate larger errors.

#### Additional parameters[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#additional-parameters "Permalink to this headline")

The map parameter enables you to add any other parameter of the Statsmodel STL function . To add a parameter, click on “ADD KEY/VALUE”, then enter the parameter name as the ‘key’, and the parameter value as the ‘value’. You may use the following parameters:

**Degree of Loess:** Degrees of the regressions used to estimate the components. It must be 0 or 1.

**Speed jump:** If the speed jump is larger than 1, the LOESS is used every seasonal\_jump points. Then, it performs linear interpolation to estimate the missing points.

**Length of the smoothers:** Number of consecutive timesteps (years, weeks..) used in estimating each value in the decomposition components. It controls how rapidly a component can change.

## Related pages[¶](https://doc.dataiku.com/dss/latest/time-series/time-series-preparation/decomposition.html#related-pages "Permalink to this headline")

* Resampling

* Interval extraction

* Extrema extraction

* Windowing
