# ERR\_FSPROVIDER\_SSH\_CONNECTION\_FAILED: Failed to establish SSH connection[¶](https://doc.dataiku.com/dss/latest/troubleshooting/errors/ERR_FSPROVIDER_SSH_CONNECTION_FAILED.html#err-fsprovider-ssh-connection-failed-failed-to-establish-ssh-connection "Permalink to this headline")

DSS tried to connect to a SSH server but couldn’t establish the connection.

This error can happen:

* when trying to create a new connection to a SSH source

* when trying to read or write a SCP or SFTP dataset

This error indicates that the connection could not be established. The message of the error will contain additional information.

Some common reasons for failure to establish the connection are:

* The connection settings (host, port, …) to the server are invalid

* The SSH server is not running or not accepting connections

* There is a firewall blocking connection attempts from DSS to the SSH server

* Credentials entered in DSS for the SSH server are invalid

## Remediation[¶](https://doc.dataiku.com/dss/latest/troubleshooting/errors/ERR_FSPROVIDER_SSH_CONNECTION_FAILED.html#remediation "Permalink to this headline")

Note

This issue can only be fixed by a DSS administrator

The first step for solving this issue is to go to the settings screen for the affected connection (Administration > Connections). You can test the connection from here.

* Refer to the documentation on SCP/SFTP sources in order to get additional information on SSH support by DSS.

* Make sure that the connection settings are correct

* If you get “connection refused” or similar errors, check that the SSH server is properly running

* Check if a firewall is blocking connections between DSS and the SSH server (this can result in either “connection refused” issues, or timeout issues)
