# Error codes[¶](https://doc.dataiku.com/dss/latest/troubleshooting/errors/index.html#error-codes "Permalink to this headline")

Below are the error codes that you may encounter while using DSS.

* ERR\_BUNDLE\_ACTIVATE\_CONNECTION\_NOT\_WRITABLE: Connection is not writable

+ Remediation

* ERR\_CLUSTERS\_INVALID\_SELECTED: Selected cluster does not exist

+ Remediation

* ERR\_CODEENV\_CONTAINER\_IMAGE\_FAILED: Could not build container image for this code environment

+ Remediation

* ERR\_CODEENV\_CONTAINER\_IMAGE\_TAG\_NOT\_FOUND: Container image tag not found for this Code environment

+ Remediation

* ERR\_CODEENV\_CREATION\_FAILED: Could not create this code environment

+ Remediation

* ERR\_CODEENV\_DELETION\_FAILED: Could not delete this code environment

+ Remediation

* ERR\_CODEENV\_EXISTING\_ENV: Code environment already exists

+ Remediation

* ERR\_CODEENV\_INCORRECT\_ENV\_TYPE: Wrong type of Code environment

+ Remediation

* ERR\_CODEENV\_INVALID\_CODE\_ENV\_ARCHIVE: Invalid code environment archive

+ Remediation

* ERR\_CODEENV\_JUPYTER\_SUPPORT\_INSTALL\_FAILED: Could not install Jupyter support in this code environment

+ Remediation

* ERR\_CODEENV\_JUPYTER\_SUPPORT\_REMOVAL\_FAILED: Could not remove Jupyter support from this code environment

+ Remediation

* ERR\_CODEENV\_MISSING\_DEEPHUB\_ENV: Code environment for deep learning does not exist

+ Remediation

* ERR\_CODEENV\_MISSING\_ENV: Code environment does not exists

+ Remediation

* ERR\_CODEENV\_MISSING\_ENV\_VERSION: Code environment version does not exists

+ Remediation

* ERR\_CODEENV\_NO\_CREATION\_PERMISSION: User not allowed to create Code environments

+ Remediation

* ERR\_CODEENV\_NO\_USAGE\_PERMISSION: User not allowed to use this Code environment

+ Remediation

* ERR\_CODEENV\_NOT\_USING\_LATEST\_DEEPHUB\_ENV: Not using latest version of code environment for deep learning

+ Remediation

* ERR\_CODEENV\_UNSUPPORTED\_OPERATION\_FOR\_ENV\_TYPE: Operation not supported for this type of Code environment

+ Remediation

* ERR\_CODEENV\_UPDATE\_FAILED: Could not update this code environment

+ Remediation

* ERR\_CONNECTION\_ALATION\_REGISTRATION\_FAILED: Failed to register Alation integration

+ Remediation

* ERR\_CONNECTION\_API\_BAD\_CONFIG: Bad configuration for connection

+ Remediation

* ERR\_CONNECTION\_AZURE\_INVALID\_CONFIG: Invalid Azure connection configuration

+ Remediation

* ERR\_CONNECTION\_DUMP\_FAILED: Failed to dump connection tables

+ Remediation

* ERR\_CONNECTION\_INVALID\_CONFIG: Invalid connection configuration

+ Remediation

* ERR\_CONNECTION\_LIST\_HIVE\_FAILED: Failed to list indexable Hive connections

+ Remediation

* ERR\_CONNECTION\_S3\_INVALID\_CONFIG: Invalid S3 connection configuration

+ Remediation

* ERR\_CONNECTION\_SQL\_INVALID\_CONFIG: Invalid SQL connection configuration

+ Remediation

* ERR\_CONNECTION\_SSH\_INVALID\_CONFIG: Invalid SSH connection configuration

+ Remediation

* ERR\_CONTAINER\_CONF\_NO\_USAGE\_PERMISSION: User not allowed to use this containerized execution configuration

+ Remediation

* ERR\_CONTAINER\_CONF\_NOT\_FOUND: The selected container configuration was not found

+ Remediation

* ERR\_CONTAINER\_IMAGE\_PUSH\_FAILED: Container image push failed

+ Remediation

* ERR\_DASHBOARD\_EXPORT\_SAND\_BOXING\_ERROR: Chrome cannot start in the “sandbox” mode

+ Remediation

* ERR\_DATASET\_ACTION\_NOT\_SUPPORTED: Action not supported for this kind of dataset

* ERR\_DATASET\_CSV\_UNTERMINATED\_QUOTE: Error in CSV file: Unterminated quote

+ Remediation

* ERR\_DATASET\_HIVE\_INCOMPATIBLE\_SCHEMA: Dataset schema not compatible with Hive

+ Remediation

* ERR\_DATASET\_INVALID\_CONFIG: Invalid dataset configuration

+ Remediation

* ERR\_DATASET\_INVALID\_FORMAT\_CONFIG: Invalid format configuration for this dataset

+ Remediation

* ERR\_DATASET\_INVALID\_METRIC\_IDENTIFIER: Invalid metric identifier

+ Remediation

* ERR\_DATASET\_INVALID\_PARTITIONING\_CONFIG: Invalid dataset partitioning configuration

+ Remediation

* ERR\_DATASET\_PARTITION\_EMPTY: Input partition is empty

+ Remediation

* ERR\_DATASET\_TRUNCATED\_COMPRESSED\_DATA: Error in compressed file: Unexpected end of file

+ Remediation

* ERR\_ENDPOINT\_INVALID\_CONFIG: Invalid configuration for API Endpoint

+ Remediation

* ERR\_FORMAT\_BOUNDING\_BOXES: Invalid format of column representing bounding boxes

+ Remediation

* ERR\_FOLDER\_INVALID\_PARTITIONING\_CONFIG: Invalid folder partitioning configuration

+ Remediation

* ERR\_FSPROVIDER\_CANNOT\_CREATE\_FOLDER\_ON\_DIRECTORY\_UNAWARE\_FS: Cannot create a folder on this type of file system

* ERR\_FSPROVIDER\_DEST\_PATH\_ALREADY\_EXISTS: Destination path already exists

+ Remediation

* ERR\_FSPROVIDER\_FSLIKE\_REACH\_OUT\_OF\_ROOT: Illegal attempt to access data out of connection root path

+ Remediation

* ERR\_FSPROVIDER\_HTTP\_CONNECTION\_FAILED: HTTP connection failed

+ Remediation

* ERR\_FSPROVIDER\_HTTP\_INVALID\_URI: Invalid HTTP URI

+ Remediation

* ERR\_FSPROVIDER\_HTTP\_REQUEST\_FAILED: HTTP request failed

+ Remediation

* ERR\_FSPROVIDER\_ILLEGAL\_PATH: Illegal path for that file system

+ Remediation

* ERR\_FSPROVIDER\_INVALID\_CONFIG: Invalid configuration

+ Remediation

* ERR\_FSPROVIDER\_INVALID\_FILE\_NAME: Invalid file name

+ Remediation

* ERR\_FSPROVIDER\_LOCAL\_LIST\_FAILED: Could not list local directory

+ Remediation

* ERR\_FSPROVIDER\_PATH\_DOES\_NOT\_EXIST: Path in dataset or folder does not exist

+ Remediation

* ERR\_FSPROVIDER\_ROOT\_PATH\_DOES\_NOT\_EXIST: Root path of the dataset or folder does not exist

+ Remediation

* ERR\_FSPROVIDER\_SSH\_CONNECTION\_FAILED: Failed to establish SSH connection

+ Remediation

* ERR\_HIVE\_HS2\_CONNECTION\_FAILED: Failed to establish HiveServer2 connection

+ Remediation

* ERR\_HIVE\_LEGACY\_UNION\_SUPPORT: Your current Hive version doesn’t support UNION clause but only supports UNION ALL, which does not remove duplicates

+ Remediation

* ERR\_METRIC\_DATASET\_COMPUTATION\_FAILED: Metrics computation completely failed

+ Remediation

* ERR\_METRIC\_ENGINE\_RUN\_FAILED: One of the metrics engine failed to run

+ Remediation

* ERR\_MISC\_DISK\_FULL: Disk is almost full

+ Remediation

* ERR\_MISC\_ENOSPC: Out of disk space

+ Remediation

* ERR\_MISC\_EOPENF: Too many open files

+ Remediation

* ERR\_ML\_MODEL\_DETAILS\_OVERFLOW: Model details exceed size limit

+ Remediation

* ERR\_ML\_VERTICA\_NOT\_SUPPORTED: Vertica ML backend is no longer supported

+ Remediation

* ERR\_NOT\_USABLE\_FOR\_USER: You may not use this connection

+ Remediation

* ERR\_OBJECT\_OPERATION\_NOT\_AVAILABLE\_FOR\_TYPE: Operation not supported for this kind of object

* ERR\_PLUGIN\_CANNOT\_LOAD: Plugin cannot be loaded

+ Remediation

* ERR\_PLUGIN\_COMPONENT\_NOT\_INSTALLED: Plugin component not installed or removed

+ Remediation

* ERR\_PLUGIN\_DEV\_INVALID\_COMPONENT\_PARAMETER: Invalid parameter for plugin component creation

+ Remediation

* ERR\_PLUGIN\_DEV\_INVALID\_DEFINITION: The descriptor of the plugin is invalid

* ERR\_PLUGIN\_INVALID\_DEFINITION: The plugin’s definition is invalid

+ Remediation

* ERR\_PLUGIN\_NOT\_INSTALLED: Plugin not installed or removed

+ Remediation

* ERR\_PLUGIN\_WITHOUT\_CODEENV: The plugin has no code env specification

+ Remediation

* ERR\_PLUGIN\_WRONG\_TYPE: Unexpected type of plugin

+ Remediation

* ERR\_PROJECT\_INVALID\_ARCHIVE: Invalid project archive

+ Remediation

* ERR\_PROJECT\_INVALID\_PROJECT\_KEY: Invalid project key

+ Remediation

* ERR\_PROJECT\_UNKNOWN\_PROJECT\_KEY: Unknown project key

+ Remediation

* ERR\_RECIPE\_CANNOT\_CHANGE\_ENGINE: Cannot change engine

+ Remediation

* ERR\_RECIPE\_CANNOT\_CHECK\_SCHEMA\_CONSISTENCY: Cannot check schema consistency

+ Remediation

* ERR\_RECIPE\_CANNOT\_CHECK\_SCHEMA\_CONSISTENCY\_EXPENSIVE: Cannot check schema consistency: expensive checks disabled

+ Remediation

* ERR\_RECIPE\_CANNOT\_CHECK\_SCHEMA\_CONSISTENCY\_NEEDS\_BUILD: Cannot compute output schema with an empty input dataset. Build the input dataset first.

+ Remediation

* ERR\_RECIPE\_CANNOT\_CHECK\_SCHEMA\_CONSISTENCY\_ON\_RECIPE\_TYPE: Cannot check schema consistency on this kind of recipe

+ Remediation

* ERR\_RECIPE\_CANNOT\_CHECK\_SCHEMA\_CONSISTENCY\_WITH\_RECIPE\_CONFIG: Cannot check schema consistency because of recipe configuration

+ Remediation

* ERR\_RECIPE\_CANNOT\_CHANGE\_ENGINE: Not compatible with Spark

+ Remediation

* ERR\_RECIPE\_CANNOT\_USE\_ENGINE: Cannot use the selected engine for this recipe

+ Remediation

* ERR\_RECIPE\_ENGINE\_NOT\_DWH: Error in recipe engine: SQLServer is not Data Warehouse edition

+ Remediation

* ERR\_RECIPE\_INCONSISTENT\_I\_O: Inconsistent recipe input or output

+ Remediation

* ERR\_RECIPE\_SYNC\_AWS\_DIFFERENT\_REGIONS: Error in recipe engine: Redshift and S3 are in different AWS regions

+ Remediation

* ERR\_RECIPE\_PDEP\_UPDATE\_REQUIRED: Partition dependecy update required

+ Remediation

* ERR\_RECIPE\_SPLIT\_INVALID\_COMPUTED\_COLUMNS: Invalid computed column

+ Remediation

* ERR\_SCENARIO\_INVALID\_STEP\_CONFIG: Invalid scenario step configuration

+ Remediation

* ERR\_SECURITY\_CRUD\_INVALID\_SETTINGS: The user attributes submitted for a change are invalid

+ Remediation

* ERR\_SECURITY\_GROUP\_EXISTS: The new requested group already exists

+ Remediation

* ERR\_SECURITY\_INVALID\_NEW\_PASSWORD: The new password is invalid

+ Remediation

* ERR\_SECURITY\_INVALID\_PASSWORD: The password hash from the database is invalid

+ Remediation

* ERR\_SECURITY\_MUS\_USER\_UNMATCHED: The DSS user is not configured to be matched onto a system user

+ Remediation

* ERR\_SECURITY\_PATH\_ESCAPE: The requested file is not within any allowed directory

+ Remediation

* ERR\_SECURITY\_USER\_EXISTS: The requested user for creation already exists

+ Remediation

* ERR\_SECURITY\_WRONG\_PASSWORD: The old password provided for password change is invalid

+ Remediation

* ERR\_SPARK\_FAILED\_DRIVER\_OOM: Spark failure: out of memory in driver

+ Description

+ Remediation

- Specific case of code recipes

- General case

* ERR\_SPARK\_FAILED\_TASK\_OOM: Spark failure: out of memory in task

+ Description

+ Remediation

- Specific case of code recipes

- General case

* ERR\_SPARK\_FAILED\_YARN\_KILLED\_MEMORY: Spark failure: killed by YARN (excessive memory usage)

+ Description

+ Remediation

* ERR\_SPARK\_PYSPARK\_CODE\_FAILED\_UNSPECIFIED: Pyspark code failed

+ Description

+ Remediation

* ERR\_SPARK\_SQL\_LEGACY\_UNION\_SUPPORT: Your current Spark version doesn’t support UNION clause but only supports UNION ALL, which does not remove duplicates

+ Remediation

* ERR\_SQL\_CANNOT\_LOAD\_DRIVER: Failed to load database driver

+ Remediation

* ERR\_SQL\_DB\_UNREACHABLE: Failed to reach database

+ Remediation

* ERR\_SQL\_IMPALA\_MEMORYLIMIT: Impala memory limit exceeded

+ Description

+ Remediation

* ERR\_SQL\_POSTGRESQL\_TOOMANYSESSIONS: too many sessions open concurrently

+ Remediation

* ERR\_SQL\_TABLE\_NOT\_FOUND: SQL Table not found

+ Remediation

* ERR\_SQL\_VERTICA\_TOOMANYROS: Error in Vertica: too many ROS

+ Remediation

* ERR\_SQL\_VERTICA\_TOOMANYSESSIONS: Error in Vertica: too many sessions open concurrently

+ Remediation

* ERR\_SYNAPSE\_CSV\_DELIMITER: Bad delimiter setup

+ Remediation

* ERR\_TRANSACTION\_FAILED\_ENOSPC: Out of disk space

+ Remediation

* ERR\_TRANSACTION\_GIT\_COMMMIT\_FAILED: Failed committing changes

+ Remediation

* ERR\_USER\_ACTION\_FORBIDDEN\_BY\_PROFILE: Your user profile does not allow you to perform this action

+ Remediation

* INFO\_RECIPE\_POTENTIAL\_FAST\_PATH: Potential fast path configuration

+ Remediation

* INFO\_RECIPE\_IMPALA\_POTENTIAL\_FAST\_PATH: Potential Impala fast path configuration

+ Remediation

* WARN\_CLUSTERS\_NONE\_SELECTED\_GLOBAL: No default cluster selected

+ Remediation

* WARN\_CLUSTERS\_NONE\_SELECTED\_PROJECT: No cluster selected in project

+ Remediation

* WARN\_CONNECTION\_HDFS\_ACL\_SUBDIRECTORY: subdirectory ACL synchronization mode

+ Remediation

* WARN\_CONNECTION\_NO\_HADOOP\_INTERFACE: no Hadoop interface set

+ Remediation

* WARN\_CONNECTION\_DATABRICKS\_NO\_AUTOFASTWRITE: automatic fast-write disabled

+ Remediation

* WARN\_CONNECTION\_SNOWFLAKE\_NO\_AUTOFASTWRITE: automatic fast-write disabled

+ Remediation

* WARN\_CONNECTION\_SPARK\_NO\_GROUP\_WITH\_DETAILS\_READ\_ACCESS: no groups allowed to read connection details

+ Remediation

* WARN\_MISC\_CODE\_ENV\_USE\_PYSPARK: pyspark installed in a code environment

+ Remediation

* WARN\_MISC\_LARGE\_INTERNAL\_DB: internal runtime database is too large

+ Remediation

* WARN\_RECIPE\_SPARK\_INDIRECT\_HDFS: No direct access to read/write HDFS dataset

+ Remediation

* WARN\_RECIPE\_SPARK\_INDIRECT\_S3: No direct access to read/write S3 dataset

+ Remediation

* WARN\_SECURITY\_NO\_CGROUPS: cgroups for resource control are not enabled

+ Remediation

* WARN\_SECURITY\_UIF\_NOT\_ENABLED: User Isolation Framework is not enabled

+ Remediation

* Undocumented error
