# Support tiers[¶](https://doc.dataiku.com/dss/latest/troubleshooting/support-tiers.html#support-tiers "Permalink to this headline")

Various features and capabilities of Dataiku DSS are not covered by the same level of support.

* Supported (default)

* Experimental

* Tier 2 support

* Not supported

* Deprecated

## Supported (default)[¶](https://doc.dataiku.com/dss/latest/troubleshooting/support-tiers.html#supported-default "Permalink to this headline")

Unless mentioned otherwise, Dataiku DSS features and capabilities are covered by Dataiku Editor Support (for Dataiku customers) and are subject to the service level agreements mentioned in your support contract.

Dataiku strives to provide workarounds or fixes for all issues in scope, for features that benefit from full support.

## Experimental[¶](https://doc.dataiku.com/dss/latest/troubleshooting/support-tiers.html#experimental "Permalink to this headline")

A number of features and capabilities are marked as “Experimental” and do not benefit from full support

Experimental means that Dataiku will make best efforts to solve issues that you may encounter with the feature. However, Dataiku may elect to consider issues as requests for future enhancements with no special priority.

Features or capabilities that are Experimental are explicitly marked as such in the documentation.

Some plugins may benefit from “Experimental” (the default for plugins is “Not supported”).

Dataiku may elect to upgrade a feature from Experimental to fully supported at any time.

## Tier 2 support[¶](https://doc.dataiku.com/dss/latest/troubleshooting/support-tiers.html#tier-2-support "Permalink to this headline")

A number of features and capabilities do not benefit from full support and instead benefit from “Tier 2” support.

Tier 2 support means that Dataiku will make best efforts to solve issues that you may encounter with the feature. However, Dataiku may elect to consider issues as requests for future enhancements with no special priority.

Features or capabilities that are covered by Tier 2 support are explicitly marked as such in the documentation.

There are several reasons for which Dataiku may choose to mark a particular feature or capability as Tier 2 support:

* The feature relies heavily on 3rd party solutions on which we do not feel we can adequately provide full support

* The feature depends on 3rd party infrastructure to which Dataiku does not have appropriate access in order to guarantee the high level of quality we strive to maintain for fully supported features.

* The feature is highly exotic or sees very little usage

Some plugins may benefit from “Tier 2 support” (the default for plugins is “Not supported”).

Dataiku may elect to upgrade a feature from Tier 2 support to fully supported at any time. Dataiku may also elect to deprecate them, with the usual deprecation warning time frames (see below).

## Not supported[¶](https://doc.dataiku.com/dss/latest/troubleshooting/support-tiers.html#not-supported "Permalink to this headline")

Some features and capabilities are marked as “Not supported”.

This means that Dataiku Support is unfortunately not able to provide support on these particular capabilities.

Features or capabilities that are “Not supported” are explicitly marked as such in the documentation.

All plugins are by default “Not supported”, unless marked otherwise.

Dataiku may elect to upgrade a feature from “Not supported” to a higher tier at any time.

## Deprecated[¶](https://doc.dataiku.com/dss/latest/troubleshooting/support-tiers.html#deprecated "Permalink to this headline")

Deprecated features are features that are scheduled for removal in a future Dataiku DSS release.

Deprecated features are still supported to their previous support tier, but we strongly advise you to migrate away from them, as they will stop being maintained in the near future.

Features or capabilities that are “Deprecated” are explicitly marked as such in the documentation.

Deprecations are always announced through our Release notes.
