# Configuration of the local security[¶](https://doc.dataiku.com/dss/latest/user-isolation/advanced/local-security.html#configuration-of-the-local-security "Permalink to this headline")

## What are the sudo authorizations?[¶](https://doc.dataiku.com/dss/latest/user-isolation/advanced/local-security.html#what-are-the-sudo-authorizations "Permalink to this headline")

When you install impersonation, DSS adds a sudoers rule in `/etc/sudoers.d/dataiku-dss-THE\_DSS\_USER-RANDOM\_STRING`

Note

If DSS could not install this sudoers rule, the impersonation setup asks you to do it manually

This rule allows DSS to run, as root, a small wrapper which is used:

* To execute user-submitted code as the end-user UNIX accounts

* To change permissions and ownerships on various files required by user-submitted code

No user-submitted code runs as root. The wrapper (also called the security module) has a specific configuration to limit which users it may run as.

## Configuration of the local security module[¶](https://doc.dataiku.com/dss/latest/user-isolation/advanced/local-security.html#configuration-of-the-local-security-module "Permalink to this headline")

When DSS runs a command on behalf of an end-user, it consults the security module configuration in `/etc/dataiku-security/INSTALL\_ID/security/security-config.ini`.

This ini file contains two important information:

* Which user groups it may change identity to. This is configured in `[users]`, in the `allowed\_user\_groups` settings.

* Where DSS is located. DSS will not change any file permissions outside of this directory, unless explicitly allowed as stated below.

### Splitted DSS datadirs[¶](https://doc.dataiku.com/dss/latest/user-isolation/advanced/local-security.html#splitted-dss-datadirs "Permalink to this headline")

In some configurations, you might have “splitted” your DSS datadir, by using symbolic links.

To allow the security module to change file permissions in the additional locations, fill in the `additional\_allowed\_file\_dirs` in the `dirs` section.
