# Reference architectures[¶](https://doc.dataiku.com/dss/latest/user-isolation/reference-architectures/index.html#reference-architectures "Permalink to this headline")

Obtaining a complete working and secure deployment of the different components of the User Isolation Framework adapted to your particular setup can be a complex task.

These reference architectures are meant to provide you with end-to-end ready-to-use deployment instructions for the most common setups. In some cases, it may be needed to combine several them if you use several of the technologies described thereafter.

Your Dataiku Sales Engineer or Customer Success Manager is ready to help for any specific deployment questions.

* Local-code only

* Setup with Cloudera

+ The two modes

+ Prerequisites and required information

+ Common setup

+ Sentry-mode

- Assumptions

- Configure your Cloudera cluster

* Do it with Cloudera Manager

* Setup Sentry

* Additional setup for Impala

* Additional setup for encrypted HDFS filesystems

- Setup driver for Impala

- Setup HDFS connections in DSS

- Configure identity mapping

- Setup Hive and Impala access

- Authorization models

* One DSS connection per database

* One database per DSS project, multiple databases per DSS connection

* More complex setups

+ DSS-ACL-synchronization-mode

- Configure your Cloudera cluster

* Do it with Cloudera Manager

* Additional setup for Impala

* Additional setup for encrypted HDFS filesystems

- Setup driver for Impala

- Configure identity mapping

- Setup Hive and Impala access

- Initialize ACLs on HDFS connections

+ Validate behavior

+ Operations (Sentry mode)

- Overview

- Adding a project

- Adding/Removing a user in a group

- Adding access to a group

- Removing access from a group

- Interaction with externally-managed data

* Existing Hive table

* Synchronized Hive table

+ Operations (ACL synchronization mode)

- Overview

- Adding a project

- Adding a user to a group

- Removing a user from a group

- Adding access to a group

- Removing access from a group

- Interaction with externally-managed data

* Existing Hive table

* Synchronized Hive table

* Setup with Hortonworks Data Platform

+ The two modes

+ Prerequisites and required information

+ Common setup

+ Ranger-mode

- Assumptions

- Configure your cluster

* With Ambari

* Setup Ranger

* Additional setup for encrypted HDFS filesystems

- Setup HDFS connections in DSS

- Configure identity mapping

- Setup Hive access

- Authorization models

* One DSS connection per database

* One database per DSS project, multiple databases per DSS connection

* More complex setups

+ DSS-ACL-synchronization-mode

- Configure your cluster

* With Ambari

* Setup Ranger

* Additional setup for encrypted HDFS filesystems

- Configure identity mapping

- Setup Hive access

- Initialize ACLs on HDFS connections

+ Validate behavior

+ Operations (Ranger mode)

- Overview

- Adding a project

- Adding/Removing a user in a group

- Adding / Removing access to a group

- Interaction with externally-managed data

* Existing Hive table

* Synchronized Hive table

+ Operations (ACL synchronization mode)

- Overview

- Adding a project

- Adding a user to a group

- Removing a user from a group

- Adding access to a group

- Removing access from a group

- Interaction with externally-managed data

* Existing Hive table

* Synchronized Hive table

* Setup with Kubernetes

+ Initial setup

+ Common setup

+ Running regular workloads

+ Running Spark workloads

- One-namespace-per-user setup

- One-namespace-per-team setup
