# Using the R API outside of DSS[¶](https://doc.dataiku.com/dss/latest/R-api/outside-usage.html#using-the-r-api-outside-of-dss "Permalink to this headline")

You can use most of the R APIs outside of DSS in your favorite IDE, such as RStudio. This allows you to develop code in that IDE and then push it to DSS.

* Installing the dataiku package

* Setting up the connection with DSS

+ Setting the current project

+ Advanced options

- Disabling SSL certificate check

## Installing the dataiku package[¶](https://doc.dataiku.com/dss/latest/R-api/outside-usage.html#installing-the-dataiku-package "Permalink to this headline")

The `dataiku` package is not available through CRAN. Instead, it must be obtained from the DSS instance itself.

§ install.packages("http(s)://DSS\_HOST:DSS\_PORT/public/packages/dataiku\_current.tar.gz", repos=NULL)

## Setting up the connection with DSS[¶](https://doc.dataiku.com/dss/latest/R-api/outside-usage.html#setting-up-the-connection-with-dss "Permalink to this headline")

In order to connect to DSS, you’ll need to supply:

* The URL of DSS

* A REST API key in order to perform actions

We strongly recommend that you use a personal API key. Please see Public API Keys for more information

There are three ways to supply this information:

* Using the RStudio integration, as described in RStudio integration

* Through code:

§ library(dataiku)

§ dkuSetRemoteDSS("http(s)://DSS\_HOST:DSS\_PORT/", "Your API Key secret")

* Through environment variables. Before starting your R process, export the following environment variables:

§ export DKU\_DSS\_URL=http(s)://DSS_HOST:DSS_PORT/

§ export DKU\_API\_KEY="Your API key secret"

* Through a configuration file. Create or edit the file `~/.dataiku/config.json` (or `%USERPROFILE%/.dataiku/config.json` on Windows), and add the following content:

§ {

§ "dss\_instances": {

§ "default": {

§ "url": "http(s)://DSS\_HOST:DSS\_PORT/",

§ "api\_key": "Your API key secret"

§ },

§ },

§ "default\_instance": "default"

§ }

You can now use most of the functions of the `dataiku` package from your own machine, independently from the DSS installation.

### Setting the current project[¶](https://doc.dataiku.com/dss/latest/R-api/outside-usage.html#setting-the-current-project "Permalink to this headline")

Most functions of the `dataiku` package require a “current project” to be set. This allows functions like `dkuReadDataset("my\_dataset\_name")` to know which project to load the dataset from.

To set the current project, use:

§ dkuSetCurrentProjectKey("PROJECT\_KEY")

### Advanced options[¶](https://doc.dataiku.com/dss/latest/R-api/outside-usage.html#advanced-options "Permalink to this headline")

#### Disabling SSL certificate check[¶](https://doc.dataiku.com/dss/latest/R-api/outside-usage.html#disabling-ssl-certificate-check "Permalink to this headline")

If your DSS has SSL enabled, the packages will verify the certificate. In order for this to work, you may need to add the root authority that signed the DSS SSL certificate to your local trust store. Please refer to your OS or Python manual for instructions.

If this is not possible, you can also disable checking the SSL certificate:

* Through code:

§ dkuSetRemoteDSS("http(s)://DSS\_HOST:DSS\_PORT/", "Your API Key secret", TRUE)

* Through environment variables: Not supported at the moment

* Through configuration file: Modify the configuration file as such:

§ {

§ "dss\_instances": {

§ "default": {

§ "url": "http(s)://DSS\_HOST:DSS\_PORT/",

§ "api\_key": "Your API key secret",

§ "no\_check\_certificate": true

§ }

§ },

§ "default\_instance": "default"

§ }
