# The main DSSClient class[¶](https://doc.dataiku.com/dss/latest/api/python/client.html#the-main-dssclient-class "Permalink to this headline")

The REST API Python client makes it easy to write client programs for the DSS REST API in Python. The REST API Python client is in the `dataikuapi` Python package.

The client is the entrypoint for many of the capabilities listed in this chapter.

For more details about the two Dataiku packages, see Python APIs, Using the APIs inside of DSS and Using the APIs outside of DSS.

## Creating a client from inside DSS[¶](https://doc.dataiku.com/dss/latest/api/python/client.html#creating-a-client-from-inside-dss "Permalink to this headline")

To work with the API, a connection needs to be established with DSS, by creating a `DSSClient` object. Once the connection is established, the DSSClient object serves as the entry point to the other calls.

The Python client can be used from inside DSS. In that case:

* It’s preinstalled, you don’t need to do anything

* You don’t need to provide any API key, as the API client will automatically inherit connection credentials from the current context

§ import dataiku

§ client = dataiku.api\_client()

§ # client is now a DSSClient and can perform all authorized actions.

§ # For example, list the project keys for which you have access

§ client.list\_project\_keys()

## Creating a client from outside DSS[¶](https://doc.dataiku.com/dss/latest/api/python/client.html#creating-a-client-from-outside-dss "Permalink to this headline")

To work with the API, a connection needs to be established with DSS, by creating a `DSSClient` object. Once the connection is established, the DSSClient object serves as the entry point to the other calls.

When running outside of DSS, you’ll first need to install the client. For that, simply install it from pip

To use the Python client from outside DSS, simply install it from pip.

§ pip install dataiku-api-client

This installs the client in the system-wide Python installation, so if you are not using virtualenv, you may need to replace `pip` by `sudo pip`.

Note that this will always install the latest version of the API client. You might need to request a version compatible with your version of DSS.

When connecting from the outside world, you need an API key. See Public API Keys for more information on how to create an API key and the associated privileges.

You also need to connect using the base URL of your DSS instance.

§ import dataikuapi

§ host = "http://localhost:11200"

§ apiKey = "some\_key"

§ client = dataikuapi.DSSClient(host, apiKey)

§ # client is now a DSSClient and can perform all authorized actions.

§ # For example, list the project keys for which the API key has access

§ client.list\_project\_keys()

### Disabling SSL certificate check[¶](https://doc.dataiku.com/dss/latest/api/python/client.html#disabling-ssl-certificate-check "Permalink to this headline")

If your DSS has SSL enabled, the package will verify the certificate. In order for this to work, you may need to add the root authority that signed the DSS SSL certificate to your local trust store. Please refer to your OS or Python manual for instructions.

If this is not possible, you can also disable checking the SSL certificate by setting `client.\_session.verify = False`

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/api/python/client.html#reference-api-doc "Permalink to this headline")

Also see Reference API documentation of dataikuapi.

*class* `dataikuapi.``DSSClient`(*host*, *api\_key=None*, *internal\_ticket=None*, *extra\_headers=None*)

Entry point for the DSS API client

`list_futures`(*as\_objects=False*, *all\_users=False*)

List the currently-running long tasks (a.k.a futures)

* Parameters: * **as\_objects** (*boolean*) – if True, each returned item will be a `dataikuapi.dss.future.DSSFuture`
* **all\_users** (*boolean*) – if True, returns futures for all users (requires admin privileges). Else, only returns futures for the user associated with the current authentication context (if any)

* Returns: list of futures. if as\_objects is True, each future in the list is a `dataikuapi.dss.future.DSSFuture`. Else, each future in the list is a dict. Each dict contains at least a ‘jobId’ field

* Return type: list of `dataikuapi.dss.future.DSSFuture` or list of dict

`list_running_scenarios`(*all\_users=False*)

List the running scenarios

* Parameters: **all\_users** (*boolean*) – if True, returns scenarios for all users (requires admin privileges). Else, only returns scenarios for the user associated with the current authentication context (if any)

* Returns: list of running scenarios, each one as a dict containing at least a “jobId” field for the
future hosting the scenario run, and a “payload” field with scenario identifiers

* Return type: list of dicts

`get_future`(*job\_id*)

Get a handle to interact with a specific long task (a.k.a future). This notably allows aborting this future.

* Parameters: **job\_id** (*str*) – the identifier of the desired future (which can be returned by `list\_futures()` or `list\_running\_scenarios()`)

* Returns: A handle to interact the future

* Return type: `dataikuapi.dss.future.DSSFuture`

`list_running_notebooks`(*as\_objects=True*)

List the currently-running Jupyter notebooks

* Parameters: **as\_objects** (*boolean*) – if True, each returned item will be a `dataikuapi.dss.notebook.DSSNotebook`

* Returns: list of notebooks. if as\_objects is True, each entry in the list is a `dataikuapi.dss.notebook.DSSNotebook`. Else, each item in the list is a dict which contains at least a “name” field.

* Return type: list of `dataikuapi.dss.notebook.DSSNotebook` or list of dict

`get_root_project_folder`()

Get a handle to interact with the root project folder.

* Returns: A `dataikuapi.dss.projectfolder.DSSProjectFolder` to interact with this project folder

`get_project_folder`(*project\_folder\_id*)

Get a handle to interact with a project folder.

* Parameters: **project\_folder\_id** (*str*) – the project folder ID of the desired project folder

* Returns: A `dataikuapi.dss.projectfolder.DSSProjectFolder` to interact with this project folder

`list_project_keys`()

List the project keys (=project identifiers).

* Returns: list of project keys identifiers, as strings

* Return type: list of strings

`list_projects`()

List the projects

* Returns: a list of projects, each as a dict. Each dictcontains at least a ‘projectKey’ field

* Return type: list of dicts

`get_project`(*project\_key*)

Get a handle to interact with a specific project.

* Parameters: **project\_key** (*str*) – the project key of the desired project

* Returns: A `dataikuapi.dss.project.DSSProject` to interact with this project

`get_default_project`()

Get a handle to the current default project, if available (i.e. if dataiku.default\_project\_key() is valid)

`create_project`(*project\_key*, *name*, *owner*, *description=None*, *settings=None*, *project\_folder\_id=None*)

Creates a new project, and return a project handle to interact with it.

Note: this call requires an API key with admin rights or the rights to create a project

* Parameters: * **project\_key** (*str*) – the identifier to use for the project. Must be globally unique
* **name** (*str*) – the display name for the project.
* **owner** (*str*) – the login of the owner of the project.
* **description** (*str*) – a description for the project.
* **settings** (*dict*) – Initial settings for the project (can be modified later). The exact possible settings are not documented.
* **project\_folder\_id** (*str*) – the project folder ID in which the project will be created (root project folder if not specified)

* Returns: A `dataikuapi.dss.project.DSSProject` project handle to interact with this project

`list_apps`()

List the apps

* Returns: a list of apps, each as a dict. Each dict contains at least a ‘appId’ field

* Return type: list of dicts

`get_app`(*app\_id*)

Get a handle to interact with a specific app.

* Parameters: **app\_id** (*str*) – the id of the desired app

* Returns: A `dataikuapi.dss.app.DSSApp` to interact with this project

`list_plugins`()

List the installed plugins

* Returns: list of dict. Each dict contains at least a ‘id’ field

`download_plugin_stream`(*plugin\_id*)

Download a development plugin, as a binary stream :param str plugin\_id: identifier of the plugin to download

* Parameters: **plugin\_id** –

* Returns: the binary stream

`download_plugin_to_file`(*plugin\_id*, *path*)

Download a development plugin to a file

* Parameters: * **plugin\_id** (*str*) – identifier of the plugin to download
* **path** (*str*) – the path where to download the plugin

* Returns: None

`install_plugin_from_archive`(*fp*)

Install a plugin from a plugin archive (as a file object)

* Parameters: **fp** (*object*) – A file-like object pointing to a plugin archive zip

`install_plugin_from_store`(*plugin\_id*)

Install a plugin from the Dataiku plugin store

* Parameters: **plugin\_id** (*str*) – identifier of the plugin to install

* Returns: A `DSSFuture` representing the install process

`install_plugin_from_git`(*repository\_url*, *checkout='master'*, *subpath=None*)

Install a plugin from a Git repository. DSS must be setup to allow access to the repository.

* Parameters: * **repository\_url** (*str*) – URL of a Git remote
* **checkout** (*str*) – branch/tag/SHA1 to commit. For example “master”
* **subpath** (*str*) – Optional, path within the repository to use as plugin. Should contain a ‘plugin.json’ file

* Returns: A `DSSFuture` representing the install process

`get_plugin`(*plugin\_id*)

Get a handle to interact with a specific plugin

* Parameters: **plugin\_id** (*str*) – the identifier of the desired plugin

* Returns: A `dataikuapi.dss.project.DSSPlugin`

`sql_query`(*query*, *connection=None*, *database=None*, *dataset\_full\_name=None*, *pre\_queries=None*, *post\_queries=None*, *type='sql'*, *extra\_conf=None*, *script\_steps=None*, *script\_input\_schema=None*, *script\_output\_schema=None*, *script\_report\_location=None*, *read\_timestamp\_without\_timezone\_as\_string=True*, *read\_date\_as\_string=False*, *project\_key=None*)

Initiate a SQL, Hive or Impala query and get a handle to retrieve the results of the query. Internally, the query is run by DSS. The database to run the query on is specified either by  passing a connection name, or by passing a database name, or by passing a dataset full name (whose connection is then used to retrieve the database)

* Parameters: * **query** (*str*) – the query to run
* **connection** (*str*) – the connection on which the query should be run (exclusive of database and dataset\_full\_name)
* **database** (*str*) – the database on which the query should be run (exclusive of connection and dataset\_full\_name)
* **dataset\_full\_name** (*str*) – the dataset on the connection of which the query should be run (exclusive of connection and database)
* **pre\_queries** (*list*) – (optional) array of queries to run before the query
* **post\_queries** (*list*) – (optional) array of queries to run after the query
* **type** (*str*) – the type of query : either ‘sql’, ‘hive’ or ‘impala’
* **project\_key** (*str*) – The project\_key on which the query should be run (especially useful for user isolation/impersonation scenario)

* Returns: A `dataikuapi.dss.sqlquery.DSSSQLQuery` query handle

`list_users`(*as\_objects=False*)

List all users setup on the DSS instance

Note: this call requires an API key with admin rights

* Returns: A list of users, as a list of `dataikuapi.dss.admin.DSSUser` if as\_objects is True, else as a list of dicts

* Return type: list of `dataikuapi.dss.admin.DSSUser` or list of dicts

`get_user`(*login*)

Get a handle to interact with a specific user

* Parameters: **login** (*str*) – the login of the desired user

* Returns: A `dataikuapi.dss.admin.DSSUser` user handle

`create_user`(*login*, *password*, *display\_name=''*, *source\_type='LOCAL'*, *groups=None*, *profile='DATA\_SCIENTIST'*)

Create a user, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **login** (*str*) – the login of the new user
* **password** (*str*) – the password of the new user
* **display\_name** (*str*) – the displayed name for the new user
* **source\_type** (*str*) – the type of new user. Admissible values are ‘LOCAL’ or ‘LDAP’
* **groups** (*list*) – the names of the groups the new user belongs to (defaults to [])
* **profile** (*str*) – The profile for the new user, can be one of READER, DATA\_ANALYST or DATA\_SCIENTIST

* Returns: A `dataikuapi.dss.admin.DSSUser` user handle

`get_own_user`()

`list_users_activity`(*enabled\_users\_only=False*)

List all users activity

Note: this call requires an API key with admin rights

* Returns: A list of user activity logs, as a list of `dataikuapi.dss.admin.DSSUserActivity` if as\_objects is True, else as a list of dict

* Return type: list of `dataikuapi.dss.admin.DSSUserActivity` or a list of dict

`get_authorization_matrix`()

Get the authorization matrix for all enabled users and groups

Note: this call requires an API key with admin rights

* Returns: The authorization matrix

* Return type: A `dataikuapi.dss.admin.DSSAuthorizationMatrix` authorization matrix handle

`list_groups`()

List all groups setup on the DSS instance

Note: this call requires an API key with admin rights

* Returns: A list of groups, as an list of dicts

* Return type: list of dicts

`get_group`(*name*)

Get a handle to interact with a specific group

* Parameters: **name** (*str*) – the name of the desired group

* Returns: A `dataikuapi.dss.admin.DSSGroup` group handle

`create_group`(*name*, *description=None*, *source\_type='LOCAL'*)

Create a group, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **name** (*str*) – the name of the new group
* **description** (*str*) – (optional) a description of the new group
* **source\_type** – the type of the new group. Admissible values are ‘LOCAL’ and ‘LDAP’

* Returns: A `dataikuapi.dss.admin.DSSGroup` group handle

`list_connections`()

List all connections setup on the DSS instance

Note: this call requires an API key with admin rights

* Returns: All connections, as a dict of connection name to connection definition

* Return type: :dict

`get_connection`(*name*)

Get a handle to interact with a specific connection

* Parameters: **name** (*str*) – the name of the desired connection

* Returns: A `dataikuapi.dss.admin.DSSConnection` connection handle

`create_connection`(*name*, *type*, *params=None*, *usable\_by='ALL'*, *allowed\_groups=None*)

Create a connection, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **name** – the name of the new connection
* **type** – the type of the new connection
* **params** (*dict*) – the parameters of the new connection, as a JSON object (defaults to {})
* **usable\_by** – the type of access control for the connection. Either ‘ALL’ (=no access control)
or ‘ALLOWED’ (=access restricted to users of a list of groups)
* **allowed\_groups** (*list*) – when using access control (that is, setting usable\_by=’ALLOWED’), the list
of names of the groups whose users are allowed to use the new connection (defaults to [])

* Returns: A `dataikuapi.dss.admin.DSSConnection` connection handle

`list_code_envs`(*as\_objects=False*)

List all code envs setup on the DSS instance

Note: this call requires an API key with admin rights

* Parameters: **as\_objects** (*boolean*) – if True, each returned item will be a `dataikuapi.dss.future.DSSCodeEnv`

* Returns: a list of code envs. Each code env is a dict containing at least “name”, “type” and “language”

`get_code_env`(*env\_lang*, *env\_name*)

Get a handle to interact with a specific code env

* Parameters: * **env\_lang** – the language (PYTHON or R) of the new code env
* **env\_name** – the name of the new code env

* Returns: A `dataikuapi.dss.admin.DSSCodeEnv` code env handle

`create_code_env`(*env\_lang*, *env\_name*, *deployment\_mode*, *params=None*)

Create a code env, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **env\_lang** – the language (PYTHON or R) of the new code env
* **env\_name** – the name of the new code env
* **deployment\_mode** – the type of the new code env
* **params** – the parameters of the new code env, as a JSON object

* Returns: A `dataikuapi.dss.admin.DSSCodeEnv` code env handle

`list_code_env_usages`()

List all usages of a code env in the instance

* Returns: a list of objects where the code env is used

`list_clusters`()

List all clusters setup on the DSS instance

* Returns:: List clusters (name, type, state)

`get_cluster`(*cluster\_id*)

Get a handle to interact with a specific cluster

* Args:: name: the name of the desired cluster

* Returns:: A `dataikuapi.dss.admin.DSSCluster` cluster handle

`create_cluster`(*cluster\_name*, *cluster\_type='manual'*, *params=None*, *cluster\_architecture='HADOOP'*)

Create a cluster, and return a handle to interact with it

* Parameters: * **cluster\_name** – the name of the new cluster
* **cluster\_type** – the type of the new cluster
* **params** – the parameters of the new cluster, as a JSON object
* **cluster\_architecture** – the architecture of the new cluster. ‘HADOOP’ or ‘KUBERNETES’

* Returns: A `dataikuapi.dss.admin.DSSCluster` cluster handle

`list_code_studio_templates`(*as\_type='listitems'*)

List all code studio templates on the DSS instance

* Returns: List of templates (name, type)

`get_code_studio_template`(*template\_id*)

Get a handle to interact with a specific code studio template

* Parameters: **template\_id** (*str*) – the template id of the desired code studio template

* Returns: A `dataikuapi.dss.admin.DSSCodeStudioTemplate` code studio template handle

`list_global_api_keys`()

List all global API keys set up on the DSS instance

Note: this call requires an API key with admin rights

* Returns: All global API keys, as a list of dicts

`get_global_api_key`(*key*)

Get a handle to interact with a specific Global API key

* Parameters: **key** (*str*) – the secret key of the desired API key

* Returns: A `dataikuapi.dss.admin.DSSGlobalApiKey` API key handle

`create_global_api_key`(*label=None*, *description=None*, *admin=False*)

Create a Global API key, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **label** (*str*) – the label of the new API key
* **description** (*str*) – the description of the new API key
* **admin** (*str*) – has the new API key admin rights (True or False)

* Returns: A `dataikuapi.dss.admin.DSSGlobalApiKey` API key handle

`list_personal_api_keys`(*as\_type='listitems'*)

List all your personal API keys.

* Parameters: **as\_type** (*str*) – How to return the personal API keys. Possible values are “listitems” and “objects”

* Returns: if as\_type=listitems, each key as a `dataikuapi.dss.admin.DSSPersonalApiKeyListItem`.
if as\_type=objects, each key is returned as a `dataikuapi.dss.admin.DSSPersonalApiKey`.

`get_personal_api_key`(*id*)

Get a handle to interact with a specific Personal API key.

* Parameters: **id** (*str*) – the id of the desired API key

* Returns: A `dataikuapi.dss.admin.DSSPersonalApiKey` API key handle

`create_personal_api_key`(*label=''*, *description=''*, *as\_type='dict'*)

Create a Personal API key associated with your user.

* Parameters: * **label** (*str*) – the label of the new API key
* **description** (*str*) – the description of the new API key
* **as\_type** (*str*) – How to return the personal API keys. Possible values are “dict” and “object”

* Returns: if as\_type=dict, the new personal API key is returned as a dict.
if as\_type=object, the new personal API key is returned as a `dataikuapi.dss.admin.DSSPersonalApiKey`.

`list_all_personal_api_keys`(*as\_type='listitems'*)

List all personal API keys. Only admin can list all the keys.

* Parameters: **as\_type** (*str*) – How to return the personal API keys. Possible values are “listitems” and “objects”

* Returns: if as\_type=listitems, each key as a `dataikuapi.dss.admin.DSSPersonalApiKeyListItem`.
if as\_type=objects, each key is returned as a `dataikuapi.dss.admin.DSSPersonalApiKey`.

`create_personal_api_key_for_user`(*user*, *label=''*, *description=''*, *as\_type='object'*)

Create a Personal API key associated on behalf of a user. Only admin can create a key for another user.

* Parameters: * **label** (*str*) – the label of the new API key
* **description** (*str*) – the description of the new API key
* **user** (*str*) – the id of the user to impersonate
* **as\_type** (*str*) – How to return the personal API keys. Possible values are “dict” and “object”

* Returns: if as\_type=dict, the new personal API key is returned as a dict.
if as\_type=object, the new personal API key is returned as a `dataikuapi.dss.admin.DSSPersonalApiKey`.

`list_meanings`()

List all user-defined meanings on the DSS instance

Note: this call requires an API key with admin rights

* Returns: A list of meanings. Each meaning is a dict

* Return type: list of dicts

`get_meaning`(*id*)

Get a handle to interact with a specific user-defined meaning

Note: this call requires an API key with admin rights

* Parameters: **id** (*str*) – the ID of the desired meaning

* Returns: A `dataikuapi.dss.meaning.DSSMeaning` meaning handle

`create_meaning`(*id*, *label*, *type*, *description=None*, *values=None*, *mappings=None*, *pattern=None*, *normalizationMode=None*, *detectable=False*)

Create a meaning, and return a handle to interact with it

Note: this call requires an API key with admin rights

* Parameters: * **id** – the ID of the new meaning
* **type** – the type of the new meaning. Admissible values are ‘DECLARATIVE’, ‘VALUES\_LIST’, ‘VALUES\_MAPPING’ and ‘PATTERN’
* **(****optional****)** (*detectable*) – the description of the new meaning
* **(****optional****)** – when type is ‘VALUES\_LIST’, the list of values, or a list of {‘value’:’the value’, ‘color’:’an optional color’}
* **(****optional****)** – when type is ‘VALUES\_MAPPING’, the mapping, as a list of objects with this
structure: {‘from’: ‘value\_1’, ‘to’: ‘value\_a’}
* **(****optional****)** – when type is ‘PATTERN’, the pattern
* **(****optional****)** – when type is ‘VALUES\_LIST’, ‘VALUES\_MAPPING’ or ‘PATTERN’, the normalization
mode to use for value matching. One of ‘EXACT’, ‘LOWERCASE’, or ‘NORMALIZED’ (not available
for ‘PATTERN’ type). Defaults to ‘EXACT’.
* **(****optional****)** – whether DSS should consider assigning the meaning to columns set to ‘Auto-detect’. Defaults to False.

* Returns: A `dataikuapi.dss.meaning.DSSMeaning` meaning handle

`list_logs`()

List all available log files on the DSS instance This call requires an API key with admin rights

* Returns: A list of log file names

`get_log`(*name*)

Get the contents of a specific log file This call requires an API key with admin rights

* Parameters: **name** (*str*) – the name of the desired log file (obtained with `list\_logs()`)

* Returns: The full content of the log file, as a string

`log_custom_audit`(*custom\_type*, *custom\_params=None*)

Log a custom entry to the audit trail

* Parameters: * **custom\_type** (*str*) – value for customMsgType in audit trail item
* **custom\_params** (*dict*) – value for customMsgParams in audit trail item (defaults to {})

`get_global_usage_summary`(*with\_per\_project=False*)

Gets a summary of the global usage of this DSS instance (number of projects, datasets, …) :returns: a summary object

`get_variables`()

Deprecated. Use `get\_global\_variables()`

`get_global_variables`()

Get the DSS instance’s variables, as a Python dictionary

This call requires an API key with admin rights

* Returns: A `dataikuapi.dss.admin.DSSInstanceVariables` handle

`set_variables`(*variables*)

Deprecated. Use `get\_global\_variables()` and `dataikuapi.dss.admin.DSSInstanceVariables.save()`

Updates the DSS instance’s variables

This call requires an API key with admin rights

It is not possible to update a single variable, you must set all of them at once. Thus, you  should only use a `variables` parameter that has been obtained using `get\_variables()`.

* Parameters: **variables** (*dict*) – the new dictionary of all variables of the instance

`get_resolved_variables`(*project\_key=None*, *typed=False*)

Get a dictionary of resolved variables of the project.

* Parameters: * **project\_key** (*str*) – the project key, defaults to the current project if any
* **typed** (*bool*) – if True, the variable values will be typed in the returned dict, defaults to False

* Returns: a dictionary with instance and project variables merged

`get_general_settings`()

Gets a handle to interact with the general settings.

This call requires an API key with admin rights

* Returns: a `dataikuapi.dss.admin.DSSGeneralSettings` handle

`create_project_from_bundle_local_archive`(*archive\_path*, *project\_folder=None*)

Create a project from a bundle archive. Warning: this method can only be used on an automation node.

* Parameters: * **archive\_path** (*string*) – Path on the local machine where the archive is
* **project\_folder** (A `dataikuapi.dss.projectfolder.DSSProjectFolder`) – the project folder in which the project will be created or None for root project folder

`create_project_from_bundle_archive`(*fp*, *project\_folder=None*)

Create a project from a bundle archive (as a file object) Warning: this method can only be used on an automation node.

* Parameters: * **fp** (*string*) – A file-like object pointing to a bundle archive zip
* **project\_folder** (A `dataikuapi.dss.projectfolder.DSSProjectFolder`) – the project folder in which the project will be created or None for root project folder

`prepare_project_import`(*f*)

Prepares import of a project archive. Warning: this method can only be used on a design node.

* Parameters: **fp** (*file-like*) – the input stream, as a file-like object

* Returns: a `TemporaryImportHandle` to interact with the prepared import

`get_apideployer`()

Gets a handle to work with the API Deployer

* Return type: `DSSAPIDeployer`

`get_projectdeployer`()

Gets a handle to work with the Project Deployer

* Return type: `DSSProjectDeployer`

`catalog_index_connections`(*connection\_names=None*, *all\_connections=False*, *indexing\_mode='FULL'*)

Triggers an indexing of multiple connections in the data catalog

* Parameters: * **connection\_names** (*list*) – list of connections to index, ignored if all\_connections=True (defaults to [])
* **all\_connections** (*bool*) – index all connections (defaults to False)

`get_scoring_libs_stream`()

Get the scoring libraries jar required for scoring with model jars that don’t include libraries. You need to close the stream after download. Failure to do so will result in the DSSClient becoming unusable.

* Returns: a jar file, as a stream

* Return type: file-like

`get_auth_info`(*with\_secrets=False*)

Returns various information about the user currently authenticated using this instance of the API client.

This method returns a dict that may contain the following keys (may also contain others):

* authIdentifier: login for a user, id for an API key

* groups: list of group names (if context is an user)

* secrets: list of dicts containing user secrets (if context is an user)

* Param: with\_secrets boolean: Return user secrets

* Returns: a dict

* Return type: dict

`get_auth_info_from_browser_headers`(*headers\_dict*, *with\_secrets=False*)

Returns various information about the DSS user authenticated by the dictionary of HTTP headers provided in headers\_dict.

This is generally only used in webapp backends

This method returns a dict that may contain the following keys (may also contain others):

* authIdentifier: login for a user, id for an API key

* groups: list of group names (if context is an user)

* secrets: list of dicts containing user secrets (if context is an user)

* Param: headers\_dict dict: Dictionary of HTTP headers

* Param: with\_secrets boolean: Return user secrets

* Returns: a dict

* Return type: dict

`get_ticket_from_browser_headers`(*headers\_dict*)

Returns a ticket for the DSS user authenticated by the dictionary of HTTP headers provided in headers\_dict.

This is only used in webapp backends

This method returns a ticket to use as a X-DKU-APITicket header

* Param: headers\_dict dict: Dictionary of HTTP headers

* Returns: a string

* Return type: string

`push_base_images`()

Push base images for Kubernetes container-execution and Spark-on-Kubernetes

`apply_kubernetes_namespaces_policies`()

Apply Kubernetes namespaces policies defined in the general settings

`get_instance_info`()

Get global information about the DSS instance

* Returns: a `DSSInstanceInfo`

`perform_instance_sanity_check`(*exclusion\_list=[]*, *wait=True*)

Run an Instance Sanity Check.

This call requires an API key with admin rights.

* Parameters: **exclusion\_list** – a string list of codes to exclude in the sanity check, as returned by `get\_sanity\_check\_codes()`

* Returns: a `dataikuapi.dss.utils.DSSInfoMessages` if wait is True, or a `dataikuapi.dss.future.DSSFuture` handle otherwise

* Return type: `dataikuapi.dss.utils.DSSInfoMessages` or `dataikuapi.dss.future.DSSFuture`

`get_sanity_check_codes`()

Return the list of codes that can be generated by the sanity check.

This call requires an API key with admin rights.

* Return type: list[str]

`get_licensing_status`()

Returns a dictionary with information about licensing status of this DSS instance

* Return type: dict

`set_license`(*license*)

Sets a new licence for DSS

* Parameters: **license** – license (content of license file)

* Returns: None

`get_object_discussions`(*project\_key*, *object\_type*, *object\_id*)

Get a handle to manage discussions on any object

* Parameters: * **project\_key** (*str*) – identifier of the project to access
* **object\_type** (*str*) – DSS object type
* **object\_id** (*str*) – DSS object ID

* Returns: the handle to manage discussions

* Return type: `dataikuapi.discussion.DSSObjectDiscussions`

`get_feature_store`()

Get a handle to interact with the Feature Store.

* Returns: a handle on the feature store

* Return type: `dataikuapi.feature\_store.DSSFeatureStore`

`list_workspaces`(*as\_objects=False*)

List the workspaces

* Returns: The list of workspaces.

`get_workspace`(*workspace\_key*)

Get a handle to interact with a specific workspace

* Parameters: **workspace\_key** (*str*) – the workspace key of the desired workspace

* Returns: A `dataikuapi.dss.workspace.DSSWorkspace` to interact with this workspace

`create_workspace`(*workspace\_key*, *name*, *permissions=None*, *description=None*, *color=None*)

Create a new workspace and return a workspace handle to interact with it

* Parameters: * **workspace\_key** (*str*) – the identifier to use for the workspace. Must be globally unique
* **name** (*str*) – the display name for the workspace.
* **permissions** (*[**dataikuapi.dss.workspace.DSSWorkspacePermissionItem**]*) – Initial permissions for the workspace (can be modified later).
* **description** (*str*) – a description for the workspace.
* **color** (*str*) – The color to use (#RRGGBB format). A random color will be assigned if not specified

* Returns: A `dataikuapi.dss.workspace.DSSWorkspace` workspace handle to interact with this workspace

*class* `dataikuapi.dssclient.``TemporaryImportHandle`(*client*, *import\_id*)

`execute`(*settings=None*)

Executes the import with provided settings.

* Parameters: **settings** (*dict*) – Dict of import settings (defaults to {}). The following settings are available:
* targetProjectKey (string): Key to import under. Defaults to the original project key
* remapping (dict): Dictionary of connection and code env remapping settings.
> 
> See example of remapping dict:
> 
> 
> 
> ```
> "remapping" : {
>   "connections": [
>     { "source": "src\_conn1", "target": "target\_conn1" },
>     { "source": "src\_conn2", "target": "target\_conn2" }
>   ],
>   "codeEnvs" : [
>     { "source": "src\_codeenv1", "target": "target\_codeenv1" },
>     { "source": "src\_codeenv2", "target": "target\_codeenv2" }
>   ]
> }
> 
> ```
> 
> 
>

@warning: You must check the ‘success’ flag
