# Connections[¶](https://doc.dataiku.com/dss/latest/api/python/connections.html#connections "Permalink to this headline")

The API exposes DSS connections, which can be created, modified and deleted through the API. These operations are restricted to API keys with the “admin rights” flag.

A list of the connections can by obtained with the list\_connections method:

§ client = DSSClient(host, apiKey)

§ dss\_connections = client.list\_connections()

§ prettyprinter.pprint(dss\_connections)

outputs

§ {   'filesystem\_managed': {   'allowManagedDatasets': True,

§ 'allowMirror': False,

§ 'allowWrite': True,

§ 'allowedGroups': [],

§ 'maxActivities': 0,

§ 'name': 'filesystem\_managed',

§ 'params': {   'root': '${dip.home}/managed\_datasets'},

§ 'type': 'Filesystem',

§ 'usableBy': 'ALL',

§ 'useGlobalProxy': True},

§ 'hdfs\_root':                  {    'allowManagedDatasets': True,

§ 'allowMirror': False,

§ 'allowWrite': True,

§ 'allowedGroups': [],

§ 'maxActivities': 0,

§ 'name': 'hdfs\_root',

§ 'params': {'database': 'dataik', 'root': '/'},

§ 'type': 'HDFS',

§ 'usableBy': 'ALL',

§ 'useGlobalProxy': False},

§ 'local\_postgress':    {    'allowManagedDatasets': True,

§ 'allowMirror': False,

§ 'allowWrite': True,

§ 'allowedGroups': [],

§ 'maxActivities': 0,

§ 'name': 'local\_postgress',

§ 'params': { 'db': 'testdb',

§ 'host': 'localhost',

§ 'password': 'admin',

§ 'port': '5432',

§ 'properties': {   },

§ 'user': 'admin'},

§ 'type': 'PostgreSQL',

§ 'usableBy': 'ALL',

§ 'useGlobalProxy': False},

§ ...

§ }

Connections can be added:

§ new\_connection\_params = {'db':'mysql\_test', 'host': 'localhost', 'password': 'admin', 'properties': [{'name': 'useSSL', 'value': 'true'}], 'user': 'admin'}

§ new\_connection = client.create\_connection('test\_connection', type='MySql', params=new\_connection\_params, usable\_by='ALLOWED', allowed\_groups=['administrators','data\_team'])

§ prettyprinter.pprint(client.list\_connections()['test\_connection'])

outputs

§ {   'allowManagedDatasets': True,

§ 'allowMirror': True,

§ 'allowWrite': True,

§ 'allowedGroups': ['data\_scientists'],

§ 'maxActivities': 0,

§ 'name': 'test\_connection',

§ 'params': {   'db': 'mysql\_test',

§ 'host': 'localhost',

§ 'password': 'admin',

§ 'properties': {   },

§ 'user': 'admin'},

§ 'type': 'MySql',

§ 'usableBy': 'ALLOWED',

§ 'useGlobalProxy': True}

To modify a connection, it is advised to first retrieve the connection definition with a get\_definition call, alter the definition, and set it back into DSS:

§ connection\_definition = new\_connection.get\_definition()

§ connection\_definition['usableBy'] = 'ALL'

§ connection\_definition['allowWrite'] = False

§ new\_connection.set\_definition(connection\_definition)

§ prettyprinter.pprint(new\_connection.get\_definition())

outputs

§ {   'allowManagedDatasets': True,

§ 'allowMirror': True,

§ 'allowWrite': False,

§ 'allowedGroups': ['data\_scientists'],

§ 'maxActivities': 0,

§ 'name': 'test\_connection',

§ 'params': {   'db': 'mysql\_test',

§ 'host': 'localhost',

§ 'password': 'admin',

§ 'properties': {   },

§ 'user': 'admin'},

§ 'type': 'MySql',

§ 'usableBy': 'ALL',

§ 'useGlobalProxy': True}

Connections can be deleted through their handle:

§ connection = client.get\_connection('test\_connection')

§ connection.delete()

## Reference documentation[¶](https://doc.dataiku.com/dss/latest/api/python/connections.html#reference-documentation "Permalink to this headline")

*class* `dataikuapi.dss.admin.``DSSConnection`(*client*, *name*)

A connection on the DSS instance. Do not create this object directly, use `dataikuapi.DSSClient.get\_connection()` instead.

`get_location_info`()

Deprecated, use get\_info

`get_info`(*contextual\_project\_key=None*)

Gets information about this connection.

Note: this call requires permissions to read connection details

* Parameters: **contextual\_project\_key** – optional project key use to resolve variables

* Returns: a `DSSConnectionInfo` containing connection information

`delete`()

Delete the connection

`get_definition`()

Get the connection’s definition (type, name, params, usage restrictions)

* Returns: The connection definition, as a dict.

The exact structure of the returned dict is not documented and depends on the connection type. Create connections using the DSS UI and call `get\_definition()` to see the  fields that are in it.

`set_definition`(*description*)

Set the connection’s definition.

You should only `set\_definition()` using an object that you obtained through `get\_definition()`,  not create a new dict.

:param dict the definition for the connection, as a dict.

`sync_root_acls`()

Resync root permissions on this connection path. This is only useful for HDFS connections when DSS has User Isolation activated with “DSS-managed HDFS ACL”

* Returns: a `DSSFuture` handle to the task of resynchronizing the permissions

`sync_datasets_acls`()

Resync permissions on datasets in this connection path. This is only useful for HDFS connections when DSS has User Isolation activated with “DSS-managed HDFS ACL”

* Returns: a `DSSFuture` handle to the task of resynchronizing the permissions

*class* `dataikuapi.dss.admin.``DSSConnectionInfo`(*data*)

A class holding read-only information about a connection. Do not create this object directly, use `DSSConnection.get\_info()` instead.

The main use case of this class is to retrieve the decrypted credentials for a connection, if allowed by the connection permissions.

Depending on the connection kind, the credential may be available using `get\_basic\_credential()`  or `get\_aws\_credential()`.

`get_type`()

Returns the type of the connection

`get_params`()

Returns the parameters of the connection, as a dict

`get_basic_credential`()

Returns the basic credential (user/password pair) for this connection, if available

* Returns: the credential, as a dict containing “user” and “password”

:rtype dict

`get_aws_credential`()

Returns the AWS credential for this connection, if available. The AWS credential can either be a keypair or a STS token triplet

* Returns: the credential, as a dict containing “accessKey”, “secretKey”, and “sessionToken” (only in the case of STS token)

:rtype dict
