# Reference API documentation of `dataiku`[¶](https://doc.dataiku.com/dss/latest/api/python/dataiku-reference.html#reference-api-documentation-of-dataiku "Permalink to this headline")

This page contains the index of classes and functions in the `dataiku` package.

* Datasets

* Managed folders

* Streaming Endpoints

* Saved models

* Metrics and checks

* Model Evaluation Stores

* Projects

## Datasets[¶](https://doc.dataiku.com/dss/latest/api/python/dataiku-reference.html#datasets "Permalink to this headline")

| `dataiku.Dataset`(name[, project\_key, ignore\_flow]) | This is a handle to obtain readers and writers on a dataiku Dataset. |

| `dataiku.core.dataset\_write.DatasetWriter`(dataset) | Handle to write to a dataset. |

## Managed folders[¶](https://doc.dataiku.com/dss/latest/api/python/dataiku-reference.html#managed-folders "Permalink to this headline")

| `dataiku.Folder`(lookup[, project\_key, …]) | This is a handle to interact with a managed folder. |

| `dataiku.core.managed\_folder.ManagedFolderWriter`(…) |  |

## Streaming Endpoints[¶](https://doc.dataiku.com/dss/latest/api/python/dataiku-reference.html#streaming-endpoints "Permalink to this headline")

| `dataiku.StreamingEndpoint`(id[, project\_key]) | This is a handle to obtain readers and writers on a dataiku streaming endpoint. |

## Saved models[¶](https://doc.dataiku.com/dss/latest/api/python/dataiku-reference.html#saved-models "Permalink to this headline")

| `dataiku.Model`(lookup[, project\_key, ignore\_flow]) | This is a handle to interact with a saved model |

## Metrics and checks[¶](https://doc.dataiku.com/dss/latest/api/python/dataiku-reference.html#metrics-and-checks "Permalink to this headline")

| `dataiku.core.metrics.ComputedMetrics`(raw) | Handle to the metrics of a DSS object and their last computed value |

| `dataiku.core.metrics.MetricDataPoint`(raw) | A value of a metric, on a partition |

| `dataiku.core.metrics.ComputedChecks`(raw) | Handle to the checks of a DSS object and their last computed value |

| `dataiku.core.metrics.CheckDataPoint`(raw) | A value of a check, on a partition |

## Model Evaluation Stores[¶](https://doc.dataiku.com/dss/latest/api/python/dataiku-reference.html#model-evaluation-stores "Permalink to this headline")

| `dataiku.core.model\_evaluation\_store.ModelEvaluationStore`(lookup) | This is a handle to interact with a model evaluation store |

| `dataiku.core.model\_evaluation\_store.ModelEvaluation`(…) | This is a handle to interact with a model evaluation |

## Projects[¶](https://doc.dataiku.com/dss/latest/api/python/dataiku-reference.html#projects "Permalink to this headline")

| `dataiku.Project`([project\_key]) | This is a handle to interact with the current project |
