# Reference API documentation of `dataikuapi`[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#reference-api-documentation-of-dataikuapi "Permalink to this headline")

This page contains the index of classes in the public API Python client (i.e. in the `dataikuapi` package) and serves as its reference API documentation

* Core classes

* Project folders

* Datasets

* Statistics worksheets

* Managed folders

* Streaming endpoint

* Recipes

* Machine Learning

* Experiment Tracking

* Code Studios

* Jobs

* Scenarios

* API node services

* User-defined meanings

* Administration

* SQL queries

* Metrics and checks

* Model Evaluation Store

## Core classes[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#core-classes "Permalink to this headline")

| `dataikuapi.DSSClient`(host[, api\_key, …]) | Entry point for the DSS API client |

| `dataikuapi.dss.project.DSSProject`(client, …) | A handle to interact with a project on the DSS instance. |

## Project folders[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#project-folders "Permalink to this headline")

| `dataikuapi.dss.projectfolder.DSSProjectFolder`(…) | A handle to interact with a project folder on the DSS instance. |

| `dataikuapi.dss.projectfolder.DSSProjectFolderSettings`(…) | A handle to interact with project folder settings |

## Datasets[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#datasets "Permalink to this headline")

| `dataikuapi.dss.dataset.DSSDataset`(client, …) | A dataset on the DSS instance. |

## Statistics worksheets[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#statistics-worksheets "Permalink to this headline")

| `dataikuapi.dss.statistics.DSSStatisticsWorksheet`(…) | A handle to interact with a worksheet. |

## Managed folders[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#managed-folders "Permalink to this headline")

| `dataikuapi.dss.managedfolder.DSSManagedFolder`(…) | A managed folder on the DSS instance |

## Streaming endpoint[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#streaming-endpoint "Permalink to this headline")

| `dataikuapi.dss.streaming\_endpoint.DSSStreamingEndpoint`(…) | A streaming endpoint on the DSS instance |

## Recipes[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#recipes "Permalink to this headline")

| `dataikuapi.dss.recipe.DSSRecipe`(client, …) | A handle to an existing recipe on the DSS instance. |

| `dataikuapi.dss.recipe.GroupingRecipeCreator`(…) | Create a Group recipe |

| `dataikuapi.dss.recipe.JoinRecipeCreator`(…) | Create a Join recipe |

| `dataikuapi.dss.recipe.StackRecipeCreator`(…) | Create a Stack recipe |

| `dataikuapi.dss.recipe.WindowRecipeCreator`(…) | Create a Window recipe |

| `dataikuapi.dss.recipe.SyncRecipeCreator`(…) | Create a Sync recipe |

| `dataikuapi.dss.recipe.SamplingRecipeCreator`(…) | Create a Sample/Filter recipe |

| `dataikuapi.dss.recipe.SQLQueryRecipeCreator`(…) | Create a SQL query recipe |

| `dataikuapi.dss.recipe.CodeRecipeCreator`(…) |  |

| `dataikuapi.dss.recipe.SplitRecipeCreator`(…) | Create a Split recipe |

| `dataikuapi.dss.recipe.EvaluationRecipeCreator`(…) | Builder for the creation of a new “Evaluate” recipe, from an input dataset, with an input saved model identifier |

## Machine Learning[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#machine-learning "Permalink to this headline")

| `dataikuapi.dss.ml.DSSMLTask`(client, …) |  |

| `dataikuapi.dss.ml.DSSMLTaskSettings`(client, …) | Object to read and modify the settings of a ML task. |

## Experiment Tracking[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#experiment-tracking "Permalink to this headline")

| `dataikuapi.dss.mlflow.DSSMLflowExtension`(…) | A handle to interact with specific endpoints of the DSS MLflow integration. |

## Code Studios[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#code-studios "Permalink to this headline")

| `dataikuapi.dss.codestudio.DSSCodeStudioObject`(…) | A handle to manage a code studio object of a project |

## Jobs[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#jobs "Permalink to this headline")

| `dataikuapi.dss.job.DSSJob`(client, …) | A job on the DSS instance |

## Scenarios[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#scenarios "Permalink to this headline")

| `dataikuapi.dss.scenario.DSSScenario`(client, …) | A handle to interact with a scenario on the DSS instance. |

| `dataikuapi.dss.scenario.DSSScenarioRun`(…) | A handle containing basic info about a past run of a scenario. |

| `dataikuapi.dss.scenario.DSSTriggerFire`(…) | A handle representing the firing of a trigger on a scenario. |

## API node services[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#api-node-services "Permalink to this headline")

| `dataikuapi.dss.apiservice.DSSAPIService`(…) | An API Service from the API Designer on the DSS instance |

| `dataikuapi.dss.ml.DSSMLTask`(client, …) |  |

## User-defined meanings[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#user-defined-meanings "Permalink to this headline")

| `dataikuapi.dss.meaning.DSSMeaning`(client, id) | A user-defined meaning on the DSS instance |

## Administration[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#administration "Permalink to this headline")

| `dataikuapi.dss.admin.DSSUser`(client, login) | A handle for a user on the DSS instance. |

| `dataikuapi.dss.admin.DSSGroup`(client, name) | A group on the DSS instance. |

| `dataikuapi.dss.admin.DSSConnection`(client, name) | A connection on the DSS instance. |

| `dataikuapi.dss.admin.DSSAuthorizationMatrix`(…) | The authorization matrix of all groups and enabled users of the DSS instance. |

| `dataikuapi.dss.admin.DSSGeneralSettings`(client) | The general settings of the DSS instance. |

| `dataikuapi.dss.admin.DSSUserImpersonationRule`([raw]) | Helper to build user-level rule items for the impersonation settings |

| `dataikuapi.dss.admin.DSSGroupImpersonationRule`([raw]) | Helper to build group-level rule items for the impersonation settings |

| `dataikuapi.dss.admin.DSSInstanceVariables`(…) | Dict containing the instance variables. |

| `dataikuapi.dss.admin.DSSGlobalUsageSummary`(data) | The summary of the usage of the DSS instance. |

| `dataikuapi.dss.admin.DSSPersonalApiKey`(…) | A personal API key on the DSS instance. |

| `dataikuapi.dss.admin.DSSPersonalApiKeyListItem`(…) | An item in a list of personal API key. |

| `dataikuapi.dss.admin.DSSGlobalApiKey`(client, key) | A global API key on the DSS instance |

| `dataikuapi.dss.future.DSSFuture`(client, job\_id) | A future on the DSS instance |

| `dataikuapi.dss.admin.DSSCluster`(client, …) | A handle to interact with a cluster on the DSS instance. |

| `dataikuapi.dss.jupyternotebook.DSSJupyterNotebook`(…) |  |

## SQL queries[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#sql-queries "Permalink to this headline")

| `dataikuapi.dss.sqlquery.DSSSQLQuery`(client, …) | A connection to a database or database-like on which queries can be run through DSS. |

## Metrics and checks[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#metrics-and-checks "Permalink to this headline")

| `dataikuapi.dss.metrics.ComputedMetrics`(raw) |  |

## Model Evaluation Store[¶](https://doc.dataiku.com/dss/latest/api/python/dataikuapi-reference.html#model-evaluation-store "Permalink to this headline")

| `dataikuapi.dss.modelevaluationstore.DSSModelEvaluationStore`(…) | A handle to interact with a model evaluation store on the DSS instance. |

| `dataikuapi.dss.modelevaluationstore.DSSModelEvaluationStoreSettings`(…) | A handle on the settings of a model evaluation store |

| `dataikuapi.dss.modelevaluationstore.DSSModelEvaluation`(…) | A handle on a model evaluation |
