# Govern Custom Pages[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-custom-pages.html#govern-custom-pages "Permalink to this headline")

Custom pages are pages that you can create and configure, and that will appear as new entries in the Govern top navigation bar.

## Retrieve the custom pages[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-custom-pages.html#retrieve-the-custom-pages "Permalink to this headline")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # list custom pages

§ custom\_pages = client.list\_custom\_pages()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-custom-pages.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.custom_page.``GovernCustomPageListItem`(*client*, *data*)

An item in a list of custom pages. Do not create this directly, use `list\_custom\_pages()`

`get_raw`()

Get the raw content of the custom page list item

* Returns: the raw content of the custom page list item as a dict

* Return type: dict

`to_custom_page`()

Gets the `GovernCustomPage` corresponding to this custom page object

* Returns: the custom page object

* Return type: a `GovernCustomPage`

*class* `dataikuapi.govern.custom_page.``GovernCustomPage`(*client*, *custom\_page\_id*)

A handle to interact with a custom page. Do not create this directly, use `get\_custom\_page()`

`get_definition`()

Get the definition of the custom page.

* Returns: the corresponding custom page definition object

* Return type: a `GovernCustomPageDefinition`

*class* `dataikuapi.govern.custom_page.``GovernCustomPageDefinition`(*client*, *custom\_page\_id*, *definition*)

The definition of a custom page. Do not create this directly, use `get\_definition()`

`get_raw`()

* Returns: the raw content of the custom page as a dict

* Return type: dict
