# Govern Blueprint Designer[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-admin-blueprint-designer.html#govern-blueprint-designer "Permalink to this headline")

The Blueprint Design is used to edit and customize blueprints and blueprint versions.

## Fork a Govern Project blueprint version[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-admin-blueprint-designer.html#fork-a-govern-project-blueprint-version "Permalink to this headline")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # get the blueprint designer

§ blueprint\_designer = client.get\_blueprint\_designer()

§ # get the provided govern\_project blueprint

§ govern\_project\_bp = blueprint\_designer.get\_blueprint('bp.system.govern\_project')

§ # fork a blueprint version

§ govern\_project\_new\_version = govern\_project\_bp.create\_version('my\_new\_version', name='My New Version', origin\_version\_id='bv.system.default')

§ # add a field and save version

§ new\_ver\_def = govern\_project\_new\_version.get\_definition()

§ new\_ver\_def.get\_raw()['fieldDefinitions']['new\_field'] = {

§ "description": "my new beautiful text field",

§ "fieldType": "TEXT",

§ "label": "my new field",

§ "required": False,

§ "sourceType": "STORE"

§ }

§ new\_ver\_def.save()

## Reference API doc[¶](https://doc.dataiku.com/dss/latest/api/python/govern/govern-admin-blueprint-designer.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminBlueprintDesigner`(*client*)

Handle to interact with the blueprint designer Do not create this directly, use `get\_blueprint\_designer()`

`list_blueprints`()

List blueprints

* Returns: the list of blueprints

* Return type: list of `GovernAdminBlueprintListItem`

`get_blueprint`(*blueprint\_id*)

Get a specific blueprint.

* Parameters: **blueprint\_id** (*str*) – the ID of the blueprint

* Returns: a blueprint object

* Return type: `GovernAdminBlueprint`

`create_blueprint`(*new\_identifier*, *blueprint*)

Create a new blueprint and returns a handle to interact with it.

* Parameters: * **new\_identifier** (*str*) – the new identifier for the blueprint. Allowed characters are letters, digits, hyphen, and underscore.
* **blueprint** (*dict*) – the blueprint definition

* Returns: The handle for the newly created blueprint

* Return type: `GovernAdminBlueprint`

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminBlueprintListItem`(*client*, *data*)

An item in a list of blueprints. Do not create this directly, use `list\_blueprints()`

`get_raw`()

Get the raw content of the blueprint list item

* Returns: the raw content of the blueprint list item as a dict

* Return type: dict

`to_blueprint`()

Gets the `GovernAdminBlueprint` corresponding to this blueprint object

* Returns: the blueprint object

* Return type: a `GovernAdminBlueprint`

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminBlueprint`(*client*, *blueprint\_id*)

A handle to interact with a blueprint as an admin on the Govern instance. Do not create this directly, use `get\_blueprint()`

`get_definition`()

Get the definition of the blueprint as an object. To modify the definition, call `save()` on the returned object.

* Returns: The blueprint definition as an object.

* Return type: `GovernAdminBlueprintDefinition`

`list_versions`()

List versions of this blueprint.

* Returns: The list of the versions of the blueprint

* Return type: list of `GovernAdminBlueprintVersionListItem`

`create_version`(*new\_identifier*, *name=None*, *origin\_version\_id=None*)

Create a new blueprint version and returns a handle to interact with it.

* Parameters: * **new\_identifier** (*str*) – The new identifier of the blueprint version. Allowed characters are letters, digits, hyphen, and underscore.
* **name** (*str*) – (Optional) The name of the blueprint version.
* **origin\_version\_id** (*str*) – (Optional) The blueprint version ID of the origin version ID if there is one.

* Returns: The handle of the newly created blueprint

* Return type: `GovernAdminBlueprintVersion`

`get_version`(*version\_id*)

Get a blueprint version and return a handle to interact with it.

* Parameters: **version\_id** (*str*) – ID of the version

* Return type: `GovernAdminBlueprintVersion`

`delete`()

Delete the blueprint. To delete a blueprint, all related blueprint versions and artifacts must be deleted beforehand.

* Returns: None

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminBlueprintDefinition`(*client*, *blueprint\_id*, *definition*)

The definition of a blueprint. Do not create this class directly, instead use `get\_definition()`

`get_raw`()

Get raw definition of the blueprint

* Returns: the raw definition of blueprint, as a dict. Modifications made to the returned object are reflected when saving

* Return type: dict

`save`()

Save this settings back to the blueprint.

* Returns: None

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminBlueprintVersionListItem`(*client*, *blueprint\_id*, *data*)

An item in a list of blueprint versions. Do not create this directly, use `list\_versions()`

`get_raw`()

Get the raw content of the blueprint version list item

* Returns: the raw content of the blueprint version list item as a dict

* Return type: dict

`to_blueprint_version`()

Gets the `GovernAdminBlueprintVersion` corresponding to this blueprint version object

* Returns: the blueprint object

* Return type: a `GovernAdminBlueprintVersion`

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminBlueprintVersion`(*client*, *blueprint\_id*, *version\_id*)

A handle to interact with a blueprint version. Do not create this directly, use `get\_version()`

`get_definition`()

Get the definition of this blueprint version. To modify the definition, call `save()` on the returned object.

* Returns: The definition of the blueprint version as an object.

* Return type: `GovernAdminBlueprintVersionDefinition`.

`get_trace`()

Get a handle of the blueprint version trace containing information about its lineage and its status.

* Returns: the trace of the blueprint version.

* Return type: `GovernAdminBlueprintVersionTrace`.

`list_signoff_configurations`()

Get the blueprint sign-off configurations of this blueprint version.

* Returns: The list of sign-off configurations

* Return type: list of `GovernAdminSignoffConfigurationListItem`

`get_signoff_configuration`(*step\_id*)

Get the sign-off configurations for a specific step

* Parameters: **step\_id** (*str*) – The step ID of the sign-off

* Returns: The signoff configuration as an object

* Return type: a `GovernAdminSignoffConfiguration`

`create_signoff_configuration`(*step\_id*, *signoff\_configuration*)

Create a new sign-off for a specific step of the workflow and return a handle to interact with it.

* Parameters: * **step\_id** (*str*) – The step ID of the workflow on which the sign-off will be added.
* **signoff\_configuration** (*dict*) – The configuration of the sign-off

* Returns: The newly created sign-off configuration as an object

* Return type: `GovernAdminSignoffConfiguration`

`delete`()

Delete the blueprint version. To delete a blueprint, all related artifacts must be deleted beforehand.

* Returns: None

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminBlueprintVersionDefinition`(*client*, *blueprint\_id*, *version\_id*, *definition*)

The blueprint version definition. Do not create this directly, use `get\_definition()`

`get_raw`()

Get raw definition of the blueprint version.

* Returns: the raw definition of blueprint version, as a dict. Modifications made to the returned object are reflected when saving

* Return type: dict

`save`(*danger\_zone\_accepted=None*)

Save this definition back to the blueprint version definition.

* Parameters: **danger\_zone\_accepted** (*boolean*) – ignore the warning about existing artifacts.
If there are existing artifacts using this blueprint version,
modifying it may break them (ie. removing artifact field values).
By default, the save call will fail in this case.
If this parameter is set to true, the call will ignore the warning and be run anyway.

* Returns: None

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminBlueprintVersionTrace`(*client*, *blueprint\_id*, *version\_id*, *trace*)

The trace of a blueprint version containing information about its lineage and its status. Do not create this directly, use `get\_trace()`

`get_raw`()

Get raw trace of the blueprint version.

* Returns: The raw trace of blueprint version, as a dict.

* Return type: dict

*property* `status`

Get the status of the blueprint version among (DRAFT, ACTIVE, or ARCHIVED)

* Return type: str

*property* `origin_version_id`

Get the origin version ID of this blueprint version

* Return type: str

`set_status`(*status*)

Directly update the status of the blueprint version.

* Parameters: **status** (*str*) – DRAFT, ACTIVE, or ARCHIVED

* Returns: None

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminSignoffConfigurationListItem`(*client*, *blueprint\_id*, *version\_id*, *data*)

An item in a list of sign-off configurations. Do not create this directly, use `list\_signoff\_configurations()`

`get_raw`()

Get the raw content of the sign-off configuration list item

* Returns: the raw content of the sign-off configuration list item as a dict

* Return type: dict

`to_signoff_configuration`()

Gets the `GovernAdminSignoffConfiguration` corresponding to this sign-off configuration object

* Returns: the sign-off configuration object

* Return type: a `GovernAdminSignoffConfiguration`

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminSignoffConfiguration`(*client*, *blueprint\_id*, *version\_id*, *step\_id*)

A handle to interact with the sign-off configuration of a specific step of a workflow. Do not create this directly, use `get\_signoff\_configuration()`

`get_definition`()

Get the definition of the configuration, to modify the configuration call `save()` on the returned object.

* Returns: The blueprint definition as an object.

* Return type: `GovernAdminSignoffConfigurationDefinition`

`delete`()

Delete the sign-off configuration.

* Returns: None

*class* `dataikuapi.govern.admin_blueprint_designer.``GovernAdminSignoffConfigurationDefinition`(*client*, *blueprint\_id*, *version\_id*, *step\_id*, *definition*)

The definition of signoff configuration. Do not create this class directly, instead use `get\_definition()`

`get_raw`()

Get raw definition of the signoff configuration

* Returns: the raw configuration of the signoff, as a dict. Modifications made to the returned object are reflected
when saving

* Return type: dict

`save`()

Save this settings back to the signoff configuration.

* Returns: None
