# API node administration API[¶](https://doc.dataiku.com/dss/latest/apinode/api/admin-api.html#api-node-administration-api "Permalink to this headline")

* The REST API

+ Request and response formats

+ Authentication

+ Methods reference

* Admin REST API Python client

+ Installing

+ Reference API doc

The API node can be managed through:

* The `apinode-admin` command-line tool. See Using the apinode-admin tool

* An HTTP REST API.

## The REST API[¶](https://doc.dataiku.com/dss/latest/apinode/api/admin-api.html#the-rest-api "Permalink to this headline")

### Request and response formats[¶](https://doc.dataiku.com/dss/latest/apinode/api/admin-api.html#request-and-response-formats "Permalink to this headline")

For POST and PUT requests, the request body must be JSON, with the Content-Type header set to application/json.

For almost all requests, the response will be JSON.

Whether a request succeeded is indicated by the HTTP status code. A 2xx status code indicates success, whereas a 4xx or 5xx status code indicates failure. When a request fails, the response body is still JSON and contains additional information about the error.

### Authentication[¶](https://doc.dataiku.com/dss/latest/apinode/api/admin-api.html#authentication "Permalink to this headline")

Authentication on the admin API is done via the use of API keys. API keys can be managed using the `apinode-admin` command-line tool.

The API key must be sent using HTTP Basic Authorization:

* Use the API key as username

* The password can remain blank

### Methods reference[¶](https://doc.dataiku.com/dss/latest/apinode/api/admin-api.html#methods-reference "Permalink to this headline")

The reference documentation of the API is available at https://doc.dataiku.com/dss/api/11/apinode-admin

## Admin REST API Python client[¶](https://doc.dataiku.com/dss/latest/apinode/api/admin-api.html#admin-rest-api-python-client "Permalink to this headline")

Dataiku provides a Python client for the API Node administration API. The client makes it easy to write client programs for the API in Python.

### Installing[¶](https://doc.dataiku.com/dss/latest/apinode/api/admin-api.html#installing "Permalink to this headline")

* The API client is already pre-installed in the DSS Python environment

* From outside of DSS, you can install the Python client by running `pip install dataiku-api-client`

### Reference API doc[¶](https://doc.dataiku.com/dss/latest/apinode/api/admin-api.html#reference-api-doc "Permalink to this headline")

*class* `dataikuapi.``APINodeAdminClient`(*uri*, *api\_key*)

Entry point for the DSS APINode admin client

`create_service`(*service\_id*)

`list_services`()

`service`(*service\_id*)

Gets a handle to interact with a service

`auth`()

Returns a handle to interact with authentication

`get_metrics`()

`import_code_env_in_cache`(*file\_dir*, *language*)

*class* `dataikuapi.apinode_admin.service.``APINodeService`(*client*, *service\_id*)

A handle to interact with the settings of an API node service

`delete`()

Deletes the API node service

`list_generations`()

`import_generation_from_archive`(*file\_path*)

`preload_generation`(*generation*)

`disable`()

Disable the service.

`enable`()

`set_generations_mapping`(*mapping*)

Setting a generations mapping automatically enables the service

`switch_to_newest`()

`switch_to_single_generation`(*generation*)

*class* `dataikuapi.apinode_admin.auth.``APINodeAuth`(*client*)

A handle to interact with authentication settings on API node

`list_keys`()

Lists the Admin API keys

`add_key`(*label=None*, *description=None*, *created\_by=None*)

Add an Admin API key. Returns the key details

`delete_key`(*key*)
