# Deploying on Kubernetes[¶](https://doc.dataiku.com/dss/latest/apinode/kubernetes/index.html#deploying-on-kubernetes "Permalink to this headline")

Using the API Deployer, you can deploy your API services to a Kubernetes cluster.

Each API Service Deployment (see Concepts) is setup on Kubernetes as:

* A *Kubernetes deployment* made of several *replicas* of a single pod

* A *Kubernetes service* to expose a publicly available URL which applications can use to query your API

* Setting up

+ Prerequisites

+ Limitations

+ Build the base image

+ Create the Kubernetes infrastructure in DSS

* Deployment on Google Kubernetes Engine

+ Setup

- Create your GKE cluster

- Prepare your local `docker` and `kubectl` commands

- Setup the infrastructure

- Deploy

+ Using GPUs

- Building an image with CUDA support

- Create a cluster with GPUs

- Add a custom reservation

* At the infrastructure level

* At the deployment level

- Deploy

* Deployment on Azure AKS

+ Setup

- Create your ACR registry

- Create your AKS cluster

- Prepare your local `az`, `docker` and `kubectl` commands

- Setup the infrastructure

- Deploy

+ Using GPUs

- Building an image with CUDA support

- Create a cluster with GPUs

- Add a custom reservation

* At the infrastructure level

* At the deployment level

- Deploy

* Deployment on AWS EKS

+ Setup

- Create your EKS cluster

- Prepare your local `aws`, `docker`, and `kubectl` commands

- Setup the infrastructure

- Deploy

+ Using GPUs

- Building an image with CUDA support

- Create a cluster with GPUs

- Add a custom reservation

* At the infrastructure level

* At the deployment level

- Deploy

* Deployment on Minikube

+ Setup

- Create the base image

- Start DSS with proper env

+ Configure infrastructure

* Managing SQL connections

+ Configuring the connection used for storage of bundled data

+ Configuring the “referenced” connections
