# Using managed EKS clusters[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#using-managed-eks-clusters "Permalink to this headline")

* Initial Setup

+ Install the EKS plugin

+ Prepare your local `aws`, `docker` and `kubectl` commands

+ Create base images

+ Create a new containerized execution configuration

* Cluster configuration

+ Connection

+ Network settings

+ Cluster nodes

* Using GPUs

+ Building an image with CUDA support

+ Enable GPU support on the cluster

+ Add a custom reservation

+ Deploy

## Initial Setup[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#initial-setup "Permalink to this headline")

### Install the EKS plugin[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#install-the-eks-plugin "Permalink to this headline")

To use Amazon Elastic Kubernetes Service (EKS), begin by installing the “EKS clusters” plugin from the Plugins store in Dataiku DSS. For more details, see the instructions for installing plugins.

### Prepare your local `aws`, `docker` and `kubectl` commands[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#prepare-your-local-aws-docker-and-kubectl-commands "Permalink to this headline")

Follow the AWS documentation to ensure the following on your local machine (where DSS is installed):

* The `aws` command has credentials that give it write access to Amazon Elastic Container Registry (ECR) and full control on EKS.

* The `kubectl` command is installed.

* The `docker` command is installed and can build images.

### Create base images[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#create-base-images "Permalink to this headline")

Build the base image by following these instructions.

### Create a new containerized execution configuration[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#create-a-new-containerized-execution-configuration "Permalink to this headline")

Go to Administration > Settings > Containerized execution, and add a new execution configuration of type “Kubernetes”.

* The image registry URL is the one given by `aws ecr describe-repositories`, without the image name.

It typically looks like `XXXXXXXXXXXX.dkr.ecr.us-east-1.amazonaws.com/PREFIX`, where `XXXXXXXXXXXX`

is your AWS account ID, `us-east-1` is the AWS region for the repository, and `PREFIX` is an optional

prefix to triage your repositories.

* Set “Image pre-push hook” to **Enable push to ECR**.

## Cluster configuration[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#cluster-configuration "Permalink to this headline")

### Connection[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#connection "Permalink to this headline")

The connection is where you define how to connect to AWS. Instead of providing a value here, we recommend that you leave it empty, and use the AWS credentials found by the `aws` command in `~/.aws/credentials`.

The connection can be defined either inline in each cluster (not recommended), or as a preset in the plugin’s settings (recommended).

### Network settings[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#network-settings "Permalink to this headline")

EKS requires two subnets in the same virtual private cloud (VPC). Your AWS administrator needs to provide you with two subnet identifiers. We strongly recommend that these subnets reside in the same VPC as the DSS host. Otherwise, you have to manually set up some peering and routing between VPCs.

Additionally, you must indicate security group ids. These security groups will be associated with the EKS cluster nodes. The networking requirement is that the DSS machine has full inbound connectivity from the EKS cluster nodes. We recommend that you use the `default` security group.

Network settings can be defined either inline in each cluster (not recommended), or as a preset in the plugin’s settings (recommended).

### Cluster nodes[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#cluster-nodes "Permalink to this headline")

This setting allows you to define the number and type of nodes in the cluster.

## Using GPUs[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#using-gpus "Permalink to this headline")

AWS provides GPU-enabled instances with NVidia GPUs. Using GPUs for containerized execution requires the following steps.

### Building an image with CUDA support[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#building-an-image-with-cuda-support "Permalink to this headline")

The base image that is built by default (see setup) does not have CUDA support and cannot use NVidia GPUs. You need to build a CUDA-enabled base image. To enable CUDA add the `--with-cuda` option to the command line:

§ ./bin/dssadmin build-base-image --type container-exec --with-cuda

We recommend that you give this image a specific tag using the `--tag` option and keep the default base image “pristine”. We also recommend that you add the DSS version number in the image tag.

§ ./bin/dssadmin build-base-image --type container-exec --with-cuda --tag dataiku-container-exec-base-cuda:X.Y.Z

where X.Y.Z is your DSS version number

Note

* This image contains CUDA 10.0 and CuDNN 7.6. You can use `--cuda-version X.Y` to specify another DSS-provided version (9.0, 10.0, 10.1, 10.2, 11.0 and 11.2 are available).

If you require other CUDA versions, you would have to create a custom image.

* Remember that depending on which CUDA version you build the base image (by default 10.0) you will need to use

the corresponding tensorflow version.

Warning

After each upgrade of DSS, you must rebuild all base images and update code envs.

Thereafter, create a new container configuration dedicated to running GPU workloads. If you specified a tag for the base image, report it in the “Base image tag” field.

### Enable GPU support on the cluster[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#enable-gpu-support-on-the-cluster "Permalink to this headline")

When you create your cluster using the EKS plugin, be sure to select a instance type with a GPU. See EC2 documentation for a full list. You’ll also need to enable the “With GPU” option in the node pool settings.

At cluster creation, the plugin will run the NVidia driver “DaemonSet” installation procedure, which needs several minutes to complete.

### Add a custom reservation[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#add-a-custom-reservation "Permalink to this headline")

For your containerized execution task to run on nodes with GPUs, and for EKS to configure the CUDA driver on your containers, the corresponding pods must be created with a custom limit (in Kubernetes parlance). This indicates that you need a specific type of resource (standard resource types are CPU and memory).

You must configure this limit in the containerized execution configuration. To do this:

* In the “Custom limits” section, add a new entry with key `nvidia.com/gpu` and value `1` (to request 1 GPU).

* Add the new entry and save your settings.

### Deploy[¶](https://doc.dataiku.com/dss/latest/containers/eks/managed.html#deploy "Permalink to this headline")

You can now deploy your GPU-based recipes and models.
