# Supported connections[¶](https://doc.dataiku.com/dss/latest/connecting/connections.html#supported-connections "Permalink to this headline")

DSS can read and write data from a variety of sources.

## Connectors[¶](https://doc.dataiku.com/dss/latest/connecting/connections.html#connectors "Permalink to this headline")

Here is a list of the available connectors in DSS.

| Type | Read | Write |

| --- | --- | --- |

| Upload your files | yes (see supported formats) | yes (see supported formats) |

| Server filesystem | yes (see supported formats) | yes (see supported formats) |

| HDFS | yes (see supported formats) | yes (see supported formats) |

| Amazon S3 | yes (see supported formats) | yes (see supported formats) |

| Google Cloud Storage | yes (see supported formats) | yes (see supported formats) |

| Azure Blob Storage | yes (see supported formats) | yes (see supported formats) |

| FTP | yes (see supported formats) | yes (see supported formats) |

| SSH (SCP and SFTP) | yes (see supported formats) | yes (see supported formats) |

| HTTP | yes (see supported formats) | no |

| Snowflake | yes | yes |

| Microsoft Azure Synapse | yes | yes |

| Google BigQuery | yes | yes |

| Amazon Redshift | yes | yes |

| PostgreSQL | yes | yes |

| MySQL | yes | yes |

| Microsoft SQL Server | yes | yes |

| Oracle | yes | yes |

| Teradata | yes | yes |

| Greenplum | yes | yes |

| Google AlloyDB | yes | yes |

| Vertica | yes | yes |

| SAP HANA | yes | yes |

| IBM Netezza | yes | yes |

| Exadata | yes | yes |

| IBM DB2 | yes (Tier 2) | yes (Tier 2) |

| Exasol | yes (Tier 2) | yes (Tier 2) |

| SingleStore | yes (Tier 2) | yes (Tier 2) |

| Other SQL databases
(JDBC driver) | best effort, not guaranteed | no, generally |

| MongoDB | yes | yes |

| Cassandra | yes | yes |

| Elasticsearch | yes | yes |

| kdb+ | yes (Experimental) | no |

| Twitter (Streaming API) | yes (Tier 2) | no |

| Generic APIs | Custom Python or R code,
plugins | Custom Python or R code,
plugins |

| PI System / PIWebAPI server | yes | yes |

## File formats[¶](https://doc.dataiku.com/dss/latest/connecting/connections.html#file-formats "Permalink to this headline")

Here is a list of the file formats that DSS can read and write for files-based connections (filesystem, HDFS, Amazon S3, HTTP, FTP, SSH).

### Standard formats[¶](https://doc.dataiku.com/dss/latest/connecting/connections.html#standard-formats "Permalink to this headline")

| Format | Read | Write |

| --- | --- | --- |

| Delimited values (CSV, TSV, …) | yes | yes |

| Fixed width | yes | no |

| Excel (from Excel 97) | yes | only via export |

| Avro | yes | yes |

| Custom format using
regular expression | yes | no |

| XML | yes | no |

| JSON | yes | no |

| ESRI Shapefiles | yes | no |

| MySQL Dump | yes | no |

| Apache Combined log
format | yes | no |

Note that file-based formats can be read compressed: ZIP, GZIP, BZ2.

### Hadoop/Spark specific formats[¶](https://doc.dataiku.com/dss/latest/connecting/connections.html#hadoop-spark-specific-formats "Permalink to this headline")

The following formats can be read and written on HDFS, S3, Azure Blob and Google Cloud Storage.

| Format | Read | Write |

| --- | --- | --- |

| Parquet | yes | yes |

| Hive ORCFile | yes | yes |

| Delta Lake | yes | no |
