# AWS Athena[¶](https://doc.dataiku.com/dss/latest/connecting/sql/athena.html#aws-athena "Permalink to this headline")

DSS can connect to AWS Athena.

Warning

**Tier 2 support**: Connection to AWS Athena is covered by Tier 2 support

Warning

Athena is not a standalone SQL database. Instead, it is an interactive query layer on top on Amazon S3 data. The integration of Athena in DSS is designed primarily for querying S3 datasets built in DSS.

## Supported[¶](https://doc.dataiku.com/dss/latest/connecting/sql/athena.html#supported "Permalink to this headline")

* Running interactive SQL notebooks on Athena based on previously-built S3 datasets

* Using Athena as charts engine for S3 datasets (partial support)

* Running SQL queries on Athena based on previously-built S3 datasets (execution and data read through Athena, write through DSS)

## Not supported[¶](https://doc.dataiku.com/dss/latest/connecting/sql/athena.html#not-supported "Permalink to this headline")

* Any form of write to Athena (writes should be made to a S3 dataset)

## Installing the JDBC driver[¶](https://doc.dataiku.com/dss/latest/connecting/sql/athena.html#installing-the-jdbc-driver "Permalink to this headline")

* The JDBC Driver can be downloaded from https://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html

* Copy the JAR file to the `lib/jdbc` folder

* Restart DSS

## Connecting to Athena[¶](https://doc.dataiku.com/dss/latest/connecting/sql/athena.html#connecting-to-athena "Permalink to this headline")

The recommended way to connect to Athena is to:

* Setup a S3 connection, including all potential advanced security options

* Create an Athena connection

* Select “From S3 connection” as the Credentials mode

* Enter the name of your S3 connection

The Athena connection will automatically use the same credentials as the S3 connection. Note that the credentials used for the S3 connection thus need Athena-related IAM permissions.
