# Code environments[¶](https://doc.dataiku.com/dss/latest/code-envs/index.html#code-environments "Permalink to this headline")

DSS allows you to create an arbitrary number of code environments. A code environment is a standalone and self-contained environment to run Python or R code.

Each code environment has its own set of packages. Environments are independent: you can install different packages or different versions of packages in different environments without interaction between them. In the case of Python environments, each environment may also use its own version of Python. You can for example have one environment running Python 2.7 and one running Python 3.6

In each location where you can run Python or R code, you can select which code environment to use.

* Operations (Python)

+ Create a code environment

+ Manage packages

+ Installing packages not available through pip

+ Managed code environment resources directory

+ Using custom package repositories

+ Containerized execution

+ Code Environments Management On Dataiku Online

* Operations (R)

+ Create a code environment

+ Manage packages

+ Using different package repositories

* Base packages

* Using Conda

+ Prerequisites

+ Using Conda environments

* Automation nodes

+ Versioning

+ Code environments from bundles

- Comparison between bundled and existing

- Preloading code environments

+ Managing code environments directly

* Non-managed code environments

+ Non-managed Python code environment

+ Non-managed R code environment

* Plugins’ code environments

+ Defining requirements of a plugin

+ Creating code environment instances for plugins

+ Plugin code environment types

* Custom options and environment

+ Examples

- Adding a trusted host for pip installs

- Adding a proxy for pip installs

- Point to a custom python package repository for pip installs

- Install from a local directory without scanning remote package indexes

- Add a conda channel for packages install

* Troubleshooting

+ Where to look for logs

+ Creation or package installation fails with gcc error

- Python.h not found

* RHEL / CentOS / Oracle Linux

* Debian / Ubuntu

* Amazon Linux 2

* SUSE Linux Enterprise Server 15

* macOS

- Other .h file not found

+ Creation of code environments fails with : No module named ‘distutils.spawn’

* Code env permissions
