# Variables expansion in code recipes[¶](https://doc.dataiku.com/dss/latest/code_recipes/variables_expansion.html#variables-expansion-in-code-recipes "Permalink to this headline")

Code recipes can use the two kinds of variables expansion in DSS:

* Expansion of user-defined variables. See Custom variables expansion

* Expansion of “Flow” variables (ie, variables that are specific to this specific recipe)

Flow variables are mostly used for partitioning-related stuff. See Partitioning variables substitutions for more information.

## Summary of expansion syntax[¶](https://doc.dataiku.com/dss/latest/code_recipes/variables_expansion.html#summary-of-expansion-syntax "Permalink to this headline")

### Pig, SQL[¶](https://doc.dataiku.com/dss/latest/code_recipes/variables_expansion.html#pig-sql "Permalink to this headline")

Both Flow and custom variables are replaced in your code using the ${VARIABLE\_NAME} syntax. For example, if you have the following code:

§ SELECT \* from mytable WHERE condition='${DKU\_DST\_ctry}';

with a variable DKU\_DST\_ctry which has value France, the following query will actually be executed:

§ SELECT \* from mytable WHERE condition='France';

### Hive[¶](https://doc.dataiku.com/dss/latest/code_recipes/variables_expansion.html#hive "Permalink to this headline")

Both Flow and custom variables are replaced in your code using the ${hiveconf:VARIABLE\_NAME} syntax. For example, if you have the following code:

§ SELECT \* from mytable WHERE condition='${hiveconf:DKU\_DST\_date}';

with a variable DKU\_DST\_date which has value 2013-12-21, the following query will actually be executed:

§ SELECT \* from mytable WHERE condition='2013-12-21';

### Python[¶](https://doc.dataiku.com/dss/latest/code_recipes/variables_expansion.html#python "Permalink to this headline")

Flow variables are available in a python dictionary called dku\_flow\_variables in the dataiku module. Example:

§ import dataiku

§ print("I am working for year %s" % (dataiku.dku\_flow\_variables["DKU\_DST\_YEAR"]))

Custom variables are available in a python dictionary retrieved by the `dataiku.get\_custom\_variables()` function. Example:

§ import dataiku

§ print("I am excluding %s" % (dataiku.get\_custom\_variables()["logs.preprocessing.excluded\_ip"]))

### R[¶](https://doc.dataiku.com/dss/latest/code_recipes/variables_expansion.html#r "Permalink to this headline")

Flow variables are retrieved using the `dkuFlowVariable(variableName)` function

§ library(dataiku)

§ dkuFlowVariable("DKU\_DST\_ctry")

Custom variables are retrieved using the `dkuCustomVariable(name)` function.

§ library(dataiku)

§ dkuCustomVariable("logs.preprocessing\_excluded\_ip")
