# Markdown[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#markdown "Permalink to this headline")

* Definition

* Syntax guide

+ Headlines

+ Formatting

+ Lists

+ Image

+ Link

+ Email link

+ Blocks

+ Table

+ Emoji

+ Users

+ Link to DSS object

+ Link to article uploaded attachment

+ Formula (LaTeX)

+ Advanced

DSS comes with editable text fields. It ensures to improve collaboration between users. They are:

* The short and long descriptions of any DSS object (in the Summary tab)

* Wiki articles of a project

* Discussions on any DSS object (by using the Discussions button on the navbar)

All of these text fields support Markdown.

## Definition[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#definition "Permalink to this headline")

Markdown is an easy-to-use syntax that aims to prettify text by allowing to use pictures, to format text, to display advanced objects like tables, lists, etc.

For more information, please visit Wikipedia and this Cheatsheet

## Syntax guide[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#syntax-guide "Permalink to this headline")

Here’s an overview of Markdown syntax.

### Headlines[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#headlines "Permalink to this headline")

§ # Title

§ ## Subtitle

### Formatting[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#formatting "Permalink to this headline")

§ You can have \*\*bold text\*\* and \_italic text\_

### Lists[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#lists "Permalink to this headline")

§ - element 1

§ - element 2

§ 1. element 1 in numbered list

§ 2. element 2 in numbered list

### Image[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#image "Permalink to this headline")

§ ![image label](https://upload.wikimedia.org/wikipedia/en/thumb/9/91/Dataiku\_logo.png/250px-Dataiku\_logo.png)

If the image is stored as an attachment to a wiki article, you can display it with:

§ ![image label](PROJECT\_KEY.attachment\_id)

### Link[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#link "Permalink to this headline")

§ [link label](https://www.dataiku.com/)

### Email link[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#email-link "Permalink to this headline")

§ <[email protected]>

### Blocks[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#blocks "Permalink to this headline")

§ > quoted text

§ > on two lines

# This is a code snippet

import os

print(os.name)

### Table[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#table "Permalink to this headline")

§ | Name       | Hobby             | Pet         |

§ |------------|-------------------|-------------|

§ | Astrid     | :fries:           | :rat:       |

§ | Clément    | :computer:        | :cat2:      |

§ | Sonia      | :champagne:       | :chicken:   |

§ | Pierre     | :surfer:          | :palm_tree: |

### Emoji[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#emoji "Permalink to this headline")

DSS Markdown comes with a list of emojis (use autocompletion by typing the character `:`):

§ :coffee: :soccer: :snowman:

### Users[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#users "Permalink to this headline")

You can mention an user with its username (use autocompletion by typing the character `@`):

§ @admin

### Link to DSS object[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#link-to-dss-object "Permalink to this headline")

You can create a link a specific DSS object:

§ [[PROJECT_KEY.Wiki Article 1]]

§ (my dataset)[dataset:PROJECT_KEY.dataset_name]

§ (my model)[saved_model:PROJECT_KEY.model_id]

§ (my project)[project:PROJECT_KEY]

### Link to article uploaded attachment[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#link-to-article-uploaded-attachment "Permalink to this headline")

You can create a link to download an attachment to a wiki article:

§ [attachment label](PROJECT\_KEY.attachment\_id)

### Formula (LaTeX)[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#formula-latex "Permalink to this headline")

You can insert mathematical formulas using the LaTeX syntax as a block:

E = \frac{mc^2}{\sqrt{1-\frac{v^2}{c^2}}}

The above formula is rendered as:

You can can also insert LaTeX-formatted formulas within paragraphs:

§ When $`a \ne 0`$, there are two solutions to $`ax^2 + bx + c = 0`$

The above paragraph is rendered as:

### Advanced[¶](https://doc.dataiku.com/dss/latest/collaboration/markdown.html#advanced "Permalink to this headline")

You can use HTML and CSS:

§ <i class="icon-dkubird" />

§ <marquee direction="right">&lt;&gt;&lt;&nbsp;&hellip;</marquee>
