# Requests[¶](https://doc.dataiku.com/dss/latest/collaboration/requests.html#requests "Permalink to this headline")

* Request types

+ Request to access a project

+ Request to execute an application

+ Request to share an object

* Managing requests

+ Notifications

+ Requests Inbox

Dataiku DSS allows any user to initiate a request to gain access to projects, datasets or other objects.

## Request types[¶](https://doc.dataiku.com/dss/latest/collaboration/requests.html#request-types "Permalink to this headline")

The following requests are available:

### Request to access a project[¶](https://doc.dataiku.com/dss/latest/collaboration/requests.html#request-to-access-a-project "Permalink to this headline")

It allows you to request to be granted project-level permissions on a project with “access requests” enabled.

Read Project Access for more details on how these requests are managed and sent.

These requests are sent to the project owner and all users with Admin permissions on the project.

### Request to execute an application[¶](https://doc.dataiku.com/dss/latest/collaboration/requests.html#request-to-execute-an-application "Permalink to this headline")

It allows you to request to be granted execute-permission on the application

Read Dataiku Applications for more details on how these requests are managed and sent.

These requests are sent to the application owner and all users with Admin permissions on the application.

### Request to share an object[¶](https://doc.dataiku.com/dss/latest/collaboration/requests.html#request-to-share-an-object "Permalink to this headline")

It allows you to request that an object be shared to a target project. This request can be initiated from the object’s right panel in several places in DSS (catalog, feature-store, flow…)

Read Shared objects for more details on how these requests are managed and sent.

These requests are sent to all users with Manage shared objects permissions on the object’s project.

## Managing requests[¶](https://doc.dataiku.com/dss/latest/collaboration/requests.html#managing-requests "Permalink to this headline")

The recipient users of the request will be notified that a new request has been made and they will be able to manage it either from the project’s security section or directly from the request inbox.

### Notifications[¶](https://doc.dataiku.com/dss/latest/collaboration/requests.html#notifications "Permalink to this headline")

All recipients of a request will be notified by a new notification on their avatars and will be able to see it from their notification panel.

Additionally all recipients of a request with a valid email address will receive an email informing them that a new request has been made.

On the other end, users who initiated a request will be notified by email when their request is approved.

Note

To receive emails:

* Users must have enabled “Email me when users request access on my projects or objects” or “Email me when I am granted access to projects” in their profile.

* DSS must be configured to send Notification emails (in Administration > Settings > Collaboration > Notifications & Integration > Notification emails).

### Requests Inbox[¶](https://doc.dataiku.com/dss/latest/collaboration/requests.html#requests-inbox "Permalink to this headline")

All requests made from DSS can be found and managed in the requests section of the recipient’s Inbox. The inbox is available from the applications menu.

Users initiating a request will not see their requests appearing in their request inboxes since only requests that need management do appear in the inbox.

If a request has been approved or rejected, its status will be updated for all other recipients of the same request. They will be able to see how and when the request was managed.
