# Visual Grammar[¶](https://doc.dataiku.com/dss/latest/flow/visual-grammar.html#visual-grammar "Permalink to this headline")

* Datasets

* Visual Recipes

* Machine Learning

* Code Recipes

* Plugin Recipes

Here’s an example of a complete project Flow in DSS:

## Datasets[¶](https://doc.dataiku.com/dss/latest/flow/visual-grammar.html#datasets "Permalink to this headline")

**Datasets** in DSS appear as **blue squares**. The icon in the center of each square represents the type of dataset. For example, an upward pointing arrow indicates that the dataset was uploaded; two cubes represent Amazon S3; and an elephant represents HDFS.

See Connecting to data for more information on the types of data that you can connect to in DSS.

The visual grammar for datasets can also acknowledge datasets that have been shared:

* Any dataset shared to another DSS project is marked with a curved arrow in the top right corner of the dataset square.

* Any dataset originating from another DSS project is marked with a black rather than a blue square.

See Shared objects for more information on exposing objects between projects.

## Visual Recipes[¶](https://doc.dataiku.com/dss/latest/flow/visual-grammar.html#visual-recipes "Permalink to this headline")

**Visual recipes** in DSS appear as **yellow circles**. The icon inside of the visual recipe indicates the type of recipe. For example, the broom icon represents a Prepare recipe; a funnel represents a Filter recipe; and a pile of squares represents a Stack recipe.

See Data preparation for an explanation of visual recipes and the transformations that they can accomplish.

## Machine Learning[¶](https://doc.dataiku.com/dss/latest/flow/visual-grammar.html#machine-learning "Permalink to this headline")

Processes related to **machine learning** are shown in **green**. Here, a barbell represents a model training event; a scatter plot represents model scoring; and the trophy shows an application of the model to a new dataset.

See Machine learning for more information about the machine learning capabilities of DSS.

## Code Recipes[¶](https://doc.dataiku.com/dss/latest/flow/visual-grammar.html#code-recipes "Permalink to this headline")

DSS allows users to execute pieces of user-defined code inside the Flow. These user-defined scripts (in languages such as Python, R, SQL, Hive and Pig) are called code recipes.

**Code recipes** are represented by **orange circles**. The icon inside the circle indicates the programming language of the recipe. For example, the “two snakes” logo represents a Python recipe, and the honeycomb icon represents a Hive recipe.

See Recipes based on code for more information on capturing user-defined code in R, Python, SQL, Hive and Pig recipes.

## Plugin Recipes[¶](https://doc.dataiku.com/dss/latest/flow/visual-grammar.html#plugin-recipes "Permalink to this headline")

The visual capabilities of DSS can be extended through the Plugins system. Code recipes can be made into reusable components with a visual interface by creating plugin recipes. **Plugin recipes** are represented by **red circles**.

See Plugins for more information on extending the features of DSS with plugins.
