# Dataiku Cloud Stacks for AWS[¶](https://doc.dataiku.com/dss/latest/installation/cloudstacks-aws/index.html#dataiku-cloud-stacks-for-aws "Permalink to this headline")

This setup allows you to deploy a fully-managed Dataiku setup on AWS. The setup comes fully-featured with Elastic AI, advanced security, R support, auto-healing setup, …

Everything is deployed in your cloud tenant, Dataiku does not have access to your data.

* Conceptual overview

+ Fleet Manager (FM)

+ Instance

+ Instance template

+ Virtual network

+ Agent

* Guided setup 1: Deploy in a new VPC with Elastic Compute

+ Description

+ Prerequisites

+ Steps

- VPC setup

- IAM setup

* Role for DSS

* Role for Fleet Manager

- Fleet Manager setup

- Start your first DSS

- (Optional) Start your first Elastic compute cluster

* Global settings

+ AWS authentication

+ Secrets encryption

+ License

+ HTTP proxy

* Virtual networks

+ Networking requirements

+ Creation

+ Edition

- Public IP address

- DNS Strategy

- HTTPS configuration

* None

* Self-signed certificate

* Custom certificate for each instance

+ Let’s Encrypt

* Instance templates and setup actions

+ SSH keypair

+ AWS credentials

- Atypical options

+ Setup actions

- Setup Kubernetes and Spark-on-Kubernetes

- Install system packages

- Add authorized SSH keys

- Set security related HTTP Headers

- Install a JDBC driver

- Run Ansible tasks

* Instances

+ Dashboard

+ Lifecycle

- Provisioning

- Deprovisioning

+ Data management

+ Settings

- General settings

- SSL settings

* None (HTTP only)

* Self-signed certificates

* Certificate/key for each instance

+ Enter key

+ Secret stored in Key Vault

* Generate certificates using Let’s Encrypt

+ Operations

* Upgrades of DSS instances

+ Updating the list of available versions

* Backup and restore of DSS instances

+ Manual snapshots

+ Automated snaphots

* Upgrading FM

* Single Sign-On

+ Users database

+ OpenID Connect

- About OIDC

* Glossary

* Compatibility

* OIDC features supported by FM

* How OIDC looks like with FM

- Setup OIDC in FM

* Registering a service provider entry for FM on the identity provider.

* Configuring FM for OIDC authentication.

+ IDP configuration

+ OIDC Client configuration

+ Examples of scopes by IDPs

* Mapping to the FM user

- Testing OIDC SSO

+ SAML

- About SAML

* Compatibility

- Setup SAML in FM

* Registering a service provider entry for FM on the identity provider.

* Configuring FM for SAML authentication.

+ Optional: configuring signed requests

* Choosing the login attribute

* Login remapping rules

* Testing SAML SSO
