# Using reverse proxies[¶](https://doc.dataiku.com/dss/latest/installation/custom/reverse-proxy.html#using-reverse-proxies "Permalink to this headline")

* HTTP deployment behind a nginx reverse proxy

* HTTPS deployment behind a nginx reverse proxy

* HTTP deployment behind an Apache reverse proxy

* If you want to expose DSS to your users on a different host and/or port than its native installation, you need: to configure a reverse proxy in front of DSS. This is the case in particular if you want to expose DSS on the
standard HTTP/80 or HTTPS/443 ports, as DSS should not run with superuser privileges.

The following configuration snippets can be adapted to forward Data Science Studio interface through an external nginx or Apache web server, to accomodate deployments where users should access it through a different base URL than that of its native host and port installation (for example to expose Data Science Studio on the standard HTTP port 80, or on a different host name).

Warning

Data Science Studio does not currently support being remapped to a base URL with a non-empty path prefix (that is, to http://HOST:PORT/PREFIX/ where PREFIX is not empty).

## HTTP deployment behind a nginx reverse proxy[¶](https://doc.dataiku.com/dss/latest/installation/custom/reverse-proxy.html#http-deployment-behind-a-nginx-reverse-proxy "Permalink to this headline")

§ # nginx reverse proxy configuration for Dataiku Data Science Studio

§ # requires nginx version 1.4 or above

§ server {

§ # Host/port on which to expose Data Science Studio to users

§ listen 80;

§ server\_name dss.example.com;

§ location / {

§ # Base url of the Data Science Studio installation

§ proxy\_pass http://DSS\_HOST:DSS\_PORT/;

§ proxy\_redirect off;

§ # Allow long queries

§ proxy\_read\_timeout 3600;

§ proxy\_send\_timeout 600;

§ # Allow large uploads

§ client\_max\_body\_size 0;

§ # Allow protocol upgrade to websocket

§ proxy\_http\_version 1.1;

§ proxy\_set\_header Host $http\_host;

§ proxy\_set\_header Upgrade $http\_upgrade;

§ proxy\_set\_header Connection "upgrade";

§ proxy\_set\_header X-Forwarded-For $proxy\_add\_x\_forwarded\_for;

§ }

§ }

## HTTPS deployment behind a nginx reverse proxy[¶](https://doc.dataiku.com/dss/latest/installation/custom/reverse-proxy.html#https-deployment-behind-a-nginx-reverse-proxy "Permalink to this headline")

DSS can also be accessed using secure HTTPS connections, provided you have a valid certificate for the host name on which it should be visible (some browsers do not accept secure WebSocket connections using untrusted certificates).

You can configure this by deploying a nginx reverse proxy server, on the same or another host than Data Science Studio, using a variant of the following configuration snippet:

§ # nginx SSL reverse proxy configuration for Dataiku Data Science Studio

§ # requires nginx version 1.4 or above

§ server {

§ # Host/port on which to expose Data Science Studio to users

§ listen 443 ssl;

§ server\_name dss.example.com;

§ ssl\_certificate /etc/nginx/ssl/dss\_server\_cert.pem;

§ ssl\_certificate\_key /etc/nginx/ssl/dss\_server.key;

§ location / {

§ # Base url of the Data Science Studio installation

§ proxy\_pass http://DSS\_HOST:DSS\_PORT/;

§ proxy\_redirect off;

§ # Allow long queries

§ proxy\_read\_timeout 3600;

§ proxy\_send\_timeout 600;

§ # Allow large uploads

§ client\_max\_body\_size 0;

§ # Allow protocol upgrade to websocket

§ proxy\_http\_version 1.1;

§ proxy\_set\_header Host $http\_host;

§ proxy\_set\_header Upgrade $http\_upgrade;

§ proxy\_set\_header Connection "upgrade";

§ proxy\_set\_header X-Forwarded-For $proxy\_add\_x\_forwarded\_for;

§ }

§ }

Note

If all DSS users access it over HTTPS, you can enforce session cookies security as described in Advanced security options.

## HTTP deployment behind an Apache reverse proxy[¶](https://doc.dataiku.com/dss/latest/installation/custom/reverse-proxy.html#http-deployment-behind-an-apache-reverse-proxy "Permalink to this headline")

The following configuration snippet can be used to forward DSS through an Apache HTTP server:

§ # Apache reverse proxy configuration for Dataiku Data Science Studio

§ # requires Apache version 2.4.5 or above

§ LoadModule proxy_module modules/mod_proxy.so

§ LoadModule proxy_http_module modules/mod_proxy_http.so

§ LoadModule proxy_wstunnel_module modules/mod_proxy_wstunnel.so

§ LoadModule rewrite_module modules/mod_rewrite.so

§ <VirtualHost \*:80>

§ ServerName dss.example.com

§ RewriteEngine On

§ RewriteCond %{HTTP:Connection} Upgrade [NC]

§ RewriteCond %{HTTP:Upgrade} WebSocket [NC]

§ RewriteRule /(.*) ws://DSS_HOST:DSS_PORT/$1 [P]

§ RewriteRule /(.*) http://DSS_HOST:DSS_PORT/$1 [P]

§ ProxyPassReverse / http://DSS_HOST:DSS_PORT/

§ ProxyPreserveHost on

§ ProxyTimeout 3600

§ </VirtualHost>
