# Requirements[¶](https://doc.dataiku.com/dss/latest/installation/requirements.html#requirements "Permalink to this headline")

## Server[¶](https://doc.dataiku.com/dss/latest/installation/requirements.html#server "Permalink to this headline")

### Linux[¶](https://doc.dataiku.com/dss/latest/installation/requirements.html#linux "Permalink to this headline")

DSS must be installed on a Linux x86-64 server.

The following Linux distributions are fully supported, in 64-bit version only:

* Red Hat Enterprise Linux, versions 7.9 and later 7.x

* Red Hat Enterprise Linux, versions 8.x

* CentOS, versionx 7.9 and later 7.x

* CentOS, versions 8.x

* AlmaLinux, version 8.4 and later 8.x

* Rocky Linux version 8.4 and later 8.x

* Ubuntu Server, versions 18.04 LTS and 20.04 LTS

* Debian 10.x

* Oracle Linux, versions 7.9 and later 7.x

* Oracle Linux, versions 8.x

* Amazon Linux 2

* SUSE Linux Enterprise Server 12 SP5

* SUSE Linux Enterprise Server 15 SP2 and 15 SP3

These distributions should be up-to-date with respect to Linux patches and updates.

Note

Running on a system with Security-Enhanced Linux (SELinux) in enforcing mode is not supported.

Support for the following Linux distributions is deprecated and will be removed in a future release:

* Red Hat Enterprise Linux, version 7.3 to 7.8

* CentOS, versions 7.3 to 7.8

* Oracle Linux, versions 7.3 to 7.8

* SUSE Linux Enterprise Server 15 and 15 SP1

### RAM[¶](https://doc.dataiku.com/dss/latest/installation/requirements.html#ram "Permalink to this headline")

A minimum of 16 GB of RAM is required. More RAM will be required if you intend to load large datasets in memory (for example in the Jupyter notebook component), or for accomodating more users.

### System[¶](https://doc.dataiku.com/dss/latest/installation/requirements.html#system "Permalink to this headline")

The hard limit on the maximum number of open files for the Unix user account running DSS should be at least 65536 (`ulimit -Hn`). For very large DSS instances, larger values may be required.

The hard limit on the maximum number of user processes for the Unix user account running DSS should be at least 65536 (`ulimit -Hu`). For very large DSS instances, larger values may be required.

The en\_US.utf8 locale must be installed.

### Filesystem[¶](https://doc.dataiku.com/dss/latest/installation/requirements.html#filesystem "Permalink to this headline")

Warning

* NFS V3 is known not to work and is not supported as the filesystem for installing DSS

* Amazon EFS is known not to work and is not supported as the filesystem for installing DSS

* NFS V4 is not supported as the filesystem for installing DSS if UIF is to be used.

* GlusterFS is known to cause instabilities and is not supported as the filesystem for installing DSS

The filesystem on which DSS is installed must be POSIX compliant, case-sensitive, support POSIX file locks, and symbolic links.

**We strongly recommend using XFS or ext4**

If DSS is to be installed with User Isolation Framework enabled, the filesystem containing the data directory must support POSIX access control lists (ACLs). In particular, it is not possible to host the DSS data directory on a NFSv4 remote filesystem in User Isolation Framework mode, as NFSv4 ACLs are different from, and not compatible with POSIX ACLs.

Note

Dataiku makes no particular recommendation as to the underlying block device. In particular, Dataiku does not have experience working with DRDB as the underlying block device and cannot provide recommendations about it.

### macOS[¶](https://doc.dataiku.com/dss/latest/installation/requirements.html#macos "Permalink to this headline")

Note

The macOS version is only available for experimentation and evaluation purpose, it is not supported for production usage

DSS can be installed on macOS version 10.12 (Sierra) and later (tested up to 10.15 (Catalina)).

8 GB of RAM is required. More RAM can be required if you intend to load large datasets in memory (for example in the IPython notebook component).

## Browser support[¶](https://doc.dataiku.com/dss/latest/installation/requirements.html#browser-support "Permalink to this headline")

Dataiku DSS is accessed over a Web browser.

The following browsers are supported:

* Google Chrome (latest version)

* Mozilla Firefox (latest ESR version)

* Microsoft Edge (latest version)

Warning

Ad blockers

Browser extensions such as Adblock Plus are known to cause serious display and performance issues when using Data Science Studio. It is highly recommended that you add the hostname on which Data Science Studio is deployed to the list of “allowed domains” in your ad blocker configuration.

Warning

Proxy support

Data Science Studio makes use of WebSockets technology. If a proxy is used between the user’s browser and the Data Science Studio server, the proxy must support WebSockets. In case of doubt, it is recommended not to use any proxy between the browser and the Data Science Studio server.
