# Prediction (Supervised ML)[¶](https://doc.dataiku.com/dss/latest/machine-learning/supervised/index.html#prediction-supervised-ml "Permalink to this headline")

Prediction (aka supervised machine learning) is used when you have a **target** variable that you want to predict. For instance, you may want to predict the price of apartments in New York City using the size of the apartments, their location and amenities in the building. In this case, the price of the apartments is the **target**, while the size of the apartments, their location and the amenities are the **features** used for prediction.

Note

Our Machine Learning Basics course provides a step-by-step explanation of how to create your first prediction model and deploy it for scoring of new records.

The rest of this document assumes that you have followed this tutorial.

Use the following steps to quickly start your first prediction model in DSS:

* Go to the Flow for your project

* Click on the dataset you want to use

* Select the *Lab*

* Select *Quick model* then *Prediction*

* Choose your target variable (one of the columns) and *Automated Machine Learning*

* Choose *Quick Prototypes* and click *Create*

* Click *Train*

* Prediction settings

+ Target settings

- Prediction type

- Multiclass classification

- Partitioned Models

+ Settings: Train / Test set

- Splitting the dataset

* Subsampling

* Splitting

+ Time ordering

+ K-fold cross-test

- Explicit extracts

+ Settings: Metrics

- Model optimization

* Custom

- Threshold optimization

+ Settings: Features handling

+ Settings: Feature generation

+ Settings: Feature reduction

+ Settings: Algorithms

+ Settings: Hyperparameters optimization

+ Setting: Weighting strategy

+ Setting: Probability calibration

+ Misc: GPU support for XGBoost

* Prediction Results

+ Decision tree analysis

+ Feature importance and Regression coefficients

+ Partial dependence

+ Subpopulation analysis

+ Individual explanations of predictions

* Individual prediction explanations

+ In the model results

+ With the scoring recipe

+ Computation methods

- Method 1: Based on the Shapley values

- Method 2: Based on ICE

- More about the computation methods

+ Limitations

* Interactive scoring

+ Edit feature values

+ Comparator

+ Publishing on a dashboard

+ Limitations

* Model exploration

+ Counterfactual explanations (for classifiers)

- Introduction

- What makes good counterfactual explanations?

- Setting a target

* Binary classification

* Multiclass classification

+ Outcome optimization (for regression models)

- Introduction

- Setting a target

+ Setting constraints

+ Interpreting results

- Plausibility

+ Limitations

* Model fairness report

+ Setup

+ Using model fairness report

- Inputs

- Metrics and Charts

* Model error analysis

+ Principle

+ Setup

+ Using model error analysis

- Error Tree

- Nodes and Charts

- Template Notebook
