# Importing MLflow models[¶](https://doc.dataiku.com/dss/latest/mlops/mlflow-models/importing.html#importing-mlflow-models "Permalink to this headline")

You can import an already trained MLflow Model into DSS as a Saved Model.

Importing MLflow models is done:

* through the API

* or using the “Deploy” action available for models in Experiment Tracking’s runs (see Deploying MLflow models).

This section focuses on the deployment through the API. It assumes that you already have a MLflow model in a *model\_directory*, i.e. a local folder on the local filesystem, or a *Managed Folder*.

This section also assumes that you already have a code environment including core packages, MLflow, scikit-learn, statsmodels, as well as the Machine Learning package you used to train your model, in the version recommended by MLflow. The Python version of this code environment should be 3.6 or higher. Please refer to Limitations and supported versions for information on supported versions.

The steps are then:

Create a DSS Saved Model using `dataikuapi.dss.project.DSSProject.create\_mlflow\_pyfunc\_model()`

Import the MLflow model into the Saved Model using `dataikuapi.dss.savedmodel.DSSSavedModel.import\_mlflow\_version\_from\_path()` or `dataikuapi.dss.savedmodel.DSSSavedModel.import\_mlflow\_version\_from\_managed\_folder()`

Use the returned MLflow handler to set metadata and evaluate the DSS Saved Model: `dataikuapi.dss.savedmodel.MLFlowVersionHandler()`

Note

You may specify a code environment when importing a project. If not, the **current** code environment defined for the project will be resolved and used.

§ import dataiku

§ # if using API from inside DSS

§ client = dataiku.api\_client()

§ project = client.get\_project("PROJECT\_ID")

§ # 1. Create DSS Saved Model

§ saved\_model = project.create\_mlflow\_pyfunc\_model(name, prediction\_type, 'code-environment-to-use')

§ # 2. Load the MLflow Model as a new version of DSS Saved Model

§ ## either from DSS host local filesystem:

§ mlflow\_version = saved\_model.import\_mlflow\_version\_from\_path("version\_id", model\_directory, 'code-environment-to-use')

§ ## or from a DSS managed folder:

§ mlflow\_version = saved\_model.import\_mlflow\_version\_from\_managed\_folder('version\_id', 'managed\_folder\_id', path\_of\_model, 'code-environment-to-use')

§ # 3. Evaluate the saved model version

§ # (Optional, only for regression or classification models with tabular input data, mandatory to have access to the saved model performance tab)

§ mlflow\_version.set\_core\_metadata(target\_column, classes, evaluation\_dataset\_name)

§ mlflow\_version.evaluate(evaluation\_dataset\_name)

Note

You may also use the API to import models trained in experiment runs, as any model stored in a managed folder.
