# Limitations and supported versions[¶](https://doc.dataiku.com/dss/latest/mlops/mlflow-models/limitations.html#limitations-and-supported-versions "Permalink to this headline")

## Import and scoring[¶](https://doc.dataiku.com/dss/latest/mlops/mlflow-models/limitations.html#import-and-scoring "Permalink to this headline")

Warning

While Dataiku makes best effort to ensure that its MLflow import support is compatible with the widest possible variety of MLflow models, MLflow imposes extremely few constraints on models, and so it is not possible to guarantee unfettered ability to use all features with all types of models.

The MLflow model import capability and scoring recipes in “direct output” mode should be compatible with MLflow models supporting the “pyfunc” variant.

As of May 2022, this means:

* Python Function

* H2O

* Keras

* Pytorch

* Scikit-learn

* TensorFlow 1 and 2

* ONNX

* MXNet Gluon

* XGBoost

* LightGBM

* Catboost

* Spacy

* FastAI

* Statsmodels

* Prophet

The import of MLflow models in DSS was successfully tested with MLflow versions 1.20.2 and 1.21.0. Later versions may also work, but modifications of implementation details of MLflow may cause bugs. Version 1.21.0 should generally be preferred, except for some older packages, such as TensorFlow 1 and Keras, whose support was removed in MLflow 1.21.0.

The following ML packages are supported in the versions specified in the below table. When using one of these packages, you should create a code environment including:

* dataiku core packages

* the specified version(s) of the ML package(s)

* the specified version of scikit-learn

* statsmodels==0.12.2

* protobuf==3.16.0

| ML package | ML packages versions | MLflow version | scikit-learn version |

| CatBoost | catboost==0.26.1 | mlflow==1.21.0 | scikit-learn>=0.20,<0.21 |

| fast.ai 1 | fastai==1.0.60 | mlflow==1.20.2 | scikit-learn>=0.20,<0.21 |

| fast.ai 2 | fastai==2.5.2 | mlflow==1.21.0 | scikit-learn>=0.20,<0.21 |

| LightGBM | lightgbm>=3.0,<3.1 | mlflow==1.21.0 | scikit-learn>=0.20,<0.21 |

| ONNX | onnx==1.10.1
onnxruntime==1.9.0
(compatible ML package) | mlflow==1.21.0 | scikit-learn>=0.20,<0.21 |

| PyTorch | torch==1.9.1,
torchvision==0.10.1,
torchmetrics==0.7.3,
pytorch-lightning==1.4.9 | mlflow==1.21.0 | scikit-learn>=0.20,<0.21 |

| scikit-learn 0.20.x | scikit-learn>=0.20,<0.21 | mlflow==1.21.0 | scikit-learn>=0.20,<0.21 |

| scikit-learn 1.0.2 | scikit-learn==1.0.2 | mlflow==1.21.0 | scikit-learn==1.0.2 |

| TensorFlow 1 / Keras 2.3 | tensorflow==1.15.0,
keras==2.3.1,
keras-preprocessing==1.1.0,
h5py==2.10.0 | mlflow==1.20.2 | scikit-learn>=0.20,<0.21 |

| TensorFlow 2 / Keras 2.6 | tensorflow==2.6.0,
tensorflow-estimator==2.6.0,
keras==2.6.0 | mlflow==1.21.0 | scikit-learn>=0.20,<0.21 |

| XGBoost | xgboost==1.5.0 | mlflow==1.21.0 | scikit-learn>=0.20,<0.21 |

§ mlflow==1.21.0,

§ scikit-learn>=0.20,<0.21,

§ statsmodels==0.12.2,

§ protobuf==3.16.0,

§ torch==1.9.1,

§ torchvision==0.10.1,

§ torchmetrics==0.7.3,

§ pytorch-lightning==1.4.9

§ mlflow==1.21.0,

§ scikit-learn>=0.20,<0.21,

§ statsmodels==0.12.2,

§ protobuf==3.16.0,

§ tensorflow==2.6.0,

§ tensorflow-estimator==2.6.0,

§ keras==2.6.0

## Evaluation[¶](https://doc.dataiku.com/dss/latest/mlops/mlflow-models/limitations.html#evaluation "Permalink to this headline")

DSS also features the evaluation of regression or classification models on tabular input data. As of May 2022, this feature has been successfully tested in the following circumstances.

Please note that this is not a guarantee that you would necessarily be able to do the same, due to the high variability of models that can be saved (even within a single framework).

In all cases, the prediction\_type should be set when importing the model. Please see below supported prediction types for the supported ML packages:

| ML package | binary classification | multiclass classification | regression |

| CatBoost | ✓ | ✓ | ✓ |

| fast.ai 1 | ✗ | ✗ | ✗ |

| fast.ai 2 | ✗ | ✗ | ✓ |

| LightGBM | ✓ | ✓ | ✓ |

| ONNX | ✓ | ✓ | ✓ |

| PyTorch | ✓ | ✓ | ✓ |

| scikit-learn 0.20.x | ✓ | ✓ | ✓ |

| scikit-learn 1.0.2 | ✓ | ✓ | ✓ |

| TensorFlow 1 / Keras 2.3 | ✗ | ✗ | ✓ |

| TensorFlow 2 / Keras 2.6 | ✓ | ✓ | ✓ |

| XGBoost | ✓ | ✓ | ✓ |
