# Operating DSS[¶](https://doc.dataiku.com/dss/latest/operations/index.html#operating-dss "Permalink to this headline")

This section covers various operations that you may need to perform during day-to-day usage of DSS.

* dsscli tool

+ Running dsscli

+ dsscli vs dssadmin

+ Security-related commands

+ Jobs-related commands

+ Scenarios-related commands

+ Projects-related commands

+ Datasets related commands

+ Managed folders related commands

+ Connections-related commands

+ Code env related commands

+ API services related commands

+ Controlling dsscli output

* The data directory

+ Finding the data directory

+ Main folders of the data directory

+ DSS is using too much space on disk

+ Managing temporary files

* Backing up

+ Full Backup

+ Other Backup Methods

+ Restoring A Backup

+ Running An Automatic Backup

+ What Can Be Excluded From The Backup

+ Govern database

* Audit trail

+ Viewing the audit trail in DSS

+ Default storage of audit trail

+ Audit centralization and dispatch

+ The DSS Event Server

+ Configuration for API nodes

+ Audit data

* The runtime databases

+ Managing internally-hosted runtime databases

+ Externally hosting runtime databases

* Logging in DSS

+ Introduction

+ Customizing log levels

+ Configuring log file rotation

* DSS Macros

* Managing DSS disk usage

+ Automating cleanup tasks through DSS macros

+ Job logs

+ Scenario logs

+ Saved models

+ Analysis data

+ Temporary files

+ Caches

+ Exports

* Understanding and tracking DSS processes

+ supervisord

+ The backend

+ The JEKs

+ The FEKs

+ Jupyter notebook server

+ Jupyter notebook kernels

+ Python / R recipes processes

+ Spark recipes

+ In-memory machine learning

+ Webapps

+ The governserver

* Tuning and controlling memory usage

+ The backend

+ The JEK

+ The FEKs

+ Jupyter notebook kernels

+ Python and R recipes

+ SparkSQL and visual recipes with Spark engine

+ PySpark, SparkR and sparklyr recipes

+ In-memory machine learning

+ Webapps

+ API node

+ The governserver

* Using cgroups for resource control

+ Prerequisites

+ Applicability

+ Configuration

+ Configuration example 1

+ Configuration example 2

+ Creating DSS-specific cgroups at boot time

+ Additional setup for User Isolation Framework deployments

* Monitoring DSS

+ Concepts

+ Historizing metrics

+ Raising alerts

+ Uninstall monitoring integration

* HTTP proxies

+ When to configure HTTP proxies

+ About WebSocket

+ Configuring a global proxy to allow DSS to access external resources

* DSS license

+ Free Edition

+ Enterprise Edition

* Compute resource usage reporting

+ Concepts

+ Enabling CRU generation and audit

+ Cluster-level reporting for Kubernetes jobs

+ Examples
