# Parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#parameters "Permalink to this headline")

Many plugin components, including datasets, recipes, macros, and webapps, can be configured through a form. The list of parameters required by a given component must be specified as a JSON array and DSS will generate the corresponding user interface.

## Describing parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#describing-parameters "Permalink to this headline")

The definition of each parameter has the following fields:

* `type`: Type of the parameter. Most common types are STRING, INT, DOUBLE, BOOLEAN, SELECT, DATASET and COLUMN. See below.

* `name`: Name of the parameter as accessible by your component’s code. We highly recommend that you\_use\_slug\_like\_names

* `label`: Name of the parameter as displayed on screen.

* `description`: Additional help to describe the parameter. Will appear on the side of the form.

* `defaultValue`: Initial value, note that the type must match the parameter type.

* `mandatory`: true/false, is this parameter required

* `visibilityCondition`: Show/hide this parameter depending on a condition. See below.

Besides, additional fields may be available for specific types of parameters. See below.

## Available parameter types[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#available-parameter-types "Permalink to this headline")

Some components take an array of parameters that describe the allowable parameters of the components. Each parameter is a JSON object with the following fields:

* `name`: Name of the parameter in the configuration dict. We highly recommend that you\_use\_slug\_like\_names.

* `type`: Type of the parameter. The most common types are STRING, INT, DOUBLE, BOOLEAN, PASSWORD, SELECT and DATASET. See below for full documentation of available types.

* `label`: The user-visible name that appears in the form.

* `description`: User-visible additional help. It appears at the right of the form when a user is filling out the component settings.

* `defaultValue`: Pre-filled value of the parameter. Type must match the field type.

* `mandatory` (boolean): When true, this parameter must be supplied in order to use the component. When false, the parameter is optional.

* `visibilityCondition`: Allows you to show/hide this parameter based on a condition. See Other topics for details.

The following fields can be used for specific types of parameters:

* `canSelectForeign` (boolean, default false): Should this parameter show foreign elements? For DATASET(S), MODEL and FOLDER only.

* `columnRole`: For COLUMN and COLUMNS only. See below for details.

* `allowedColumnTypes`: For COLUMN and COLUMNS only. See below for details.

* `selectChoices`: For SELECT only. See below for details.

* `datasetParamName`: For DATASET\_COLUMN only. Parameter name of the related dataset. See below for details.

* `apiServiceParamName`: For API\_SERVICE\_VERSION only. Parameter name of the related API Service. See below for details.

* `credentialRequestSettings`: For CREDENTIAL\_REQUEST only. See below for details.

Note

In the Python recipes, the parameters are the result of JSON deserialization. As such, you’ll only get the following data types: string, float, bool (in other words, a INT parameter is received as a float in Python)

### String parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#string-parameters "Permalink to this headline")

* **STRING**: A simple string

* **TEXTAREA**: A string, but the UI shows a multi-line control suitable for entering long text.

* **STRINGS**: A list of strings

In the case of STRINGS, you may specify:

* `"allowDuplicates": false`: to prevent duplicate strings in the parameter (case sensitive)

Example:

§ {

§ "type": "STRING",

§ "name": "favorite\_quote",

§ "label": "What's your favorite quote from Camus?",

§ "defaultValue": "At any street corner the feeling of absurdity can strike any man in the face."

§ }

### Numerical parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#numerical-parameters "Permalink to this headline")

* **INT**: An integer.

* **DOUBLE**: A decimal

You can provide `minI`/`maxI` (for INT) and `minD`/`maxD` (for DOUBLE) to force a value interval.

Example:

§ {

§ "type": "INT",

§ "name": "age",

§ "label": "Age of the captain",

§ "minI": 0,

§ "maxI": 122

§ }

Note

The parameters are obtained by the component’s code after JSON serialization, so an INT parameter is received as a float by the component’s code, and the only difference between INT and DOUBLE is the specific UI.

### Boolean parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#boolean-parameters "Permalink to this headline")

* **BOOLEAN**: A boolean, displayed as a checkbox.

Example:

§ {

§ "type": "BOOLEAN",

§ "name": "the\_other\_boolean\_g",

§ "label": "I accept",

§ "defaultValue": false

§ }

### Multi-choice parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#multi-choice-parameters "Permalink to this headline")

* **SELECT**: Select one value among possible choices.

* **MULTISELECT**: Select several values among possible choices.

SELECT and MULTISELECT parameters must have one of the two fields:

* `selectChoices`: list of {value, label} if the list is static

* `getChoicesFromPython`: true if the plugin contains a python function that can generate dynamically the list of {value, label}. For details see below in the advanced section.

Selects allow you to propose multiple choices, and have the user select one (and only one). Each choice has an identifier and a user-visible long string.

Example of a simple select:

§ {

§ "type": "SELECT",

§ "name": "egg\_type",

§ "label": "Choose your eggs",

§ "selectChoices": [

§ { "value": "scrambled", "label": "Scrambled"},

§ { "value": "sunny\_up", "label": "Sunny-side up"}

§ ]

§ }

### Preset parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#preset-parameters "Permalink to this headline")

You can select some pre-defined values with a **PRESET** parameter.

When you develop or use a plugin, you may need to share some settings across different components. For example, a custom recipe or a custom dataset may have some common parameters like user credentials. In this case, we recommend using presets to store and interact with these shared parameters.

It is possible to input the value of a PRESET :

* **At the instance level:** The admins of the instance input the values of the presets in the settings tab of the plugin.

* **At the project level:** The administrators of the project input the values in the settings of the project. Settings > Plugins presets.

* **At the component level:** If the settings of the preset allow it, the user can also input the values of the preset in the settings of the component.

To use a PRESET type, you must :

Create a Parameter Set in your plugin. If you edit the plugin with the plugin developer tools (see the tutorial for an introduction), go to the main page of the plugin > click on **+ New component > Parameter set**.

Reference the Parameter set when defining the preset using the field :

* `parameterSetId`: parameter set of which we should see the values listed.

Example

§ {

§ "type": "PRESET",

§ "name": "aws\_account",

§ "label": "Choose which account to use",

§ "parameterSetId": "aws\_accounts"

§ }

The Amazon comprehend plugin contains preset parameters. See its source code to see how to set up a preset and a parameter set.

### Passwords parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#passwords-parameters "Permalink to this headline")

* **PASSWORD**: A simple string, but the UI hides the typing

Passwords (for example, to access an external API) should typically be plugin parameters, not component parameters, so that they are set only once and visible only to admins. See below for details on plugin parameters.

### Credential requests[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#credential-requests "Permalink to this headline")

* **CREDENTIAL\_REQUEST**: This generates a request for a per-user credential. Once a preset of the parameter set is instantiated, each user will then be able to add their personal credential in Profile > Credentials. This parameter type is only accepted in the `params` section of a parameter set.

A `credentialRequestSettings` object must be added to define the credential request. This object contains:

* `type`: The type of credential. Must be one of `SINGLE\_FIELD`, `BASIC`, or `OAUTH2`

For `OAUTH2`, the following fields must/may be added to the `credentialRequestSettings` object:

* `authorizationEndpoint`: The authorization endpoint of the OAuth2 authorization server

* `tokenEndpoint`: The token endpoint of the OAuth2 authorization server

* `scope`: [Optional] Should be a space delimited string

* `resources`: [Optional] Rarely used. Must be a list of strings

Additionally for `OAUTH2`, once a preset of this parameter set is instantiated, you must enter in the Client ID and Client Secret (if applicable) that is configured for your registered application on the OAuth2 server. See OAuth2 credentials for more information.

These credentials will then be available for use by plugin code (see Read settings of a plugin). For example, for a `BASIC` credential, the username and password will be available in the settings, while for an `OAUTH2` credential, a valid OAuth2 access token will be in the settings.

Examples:

§ {

§ "type": "CREDENTIAL\_REQUEST",

§ "name": "basic\_credentials",

§ "label": "Basic credentials",

§ "credentialRequestSettings": {

§ "type": "BASIC"

§ }

§ },

§ {

§ "type": "CREDENTIAL\_REQUEST",

§ "name": "oauth\_credentials",

§ "label": "OAuth2 credentials",

§ "credentialRequestSettings": {

§ "type": "OAUTH2",

§ "authorizationEndpoint": "https://authserver.com/oauth2/authorize",

§ "tokenEndpoint": "https://authserver.com/oauth2/token",

§ "scope": "scope1 user.scope2"

§ }

§ }

### Date parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#date-parameters "Permalink to this headline")

* **DATE**: A simple date, that you will be able to pick from a calendar.

Example:

§ {

§ "type": "DATE",

§ "name": "release\_date",

§ "label": "Release Date"

§ }

### DSS object parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#dss-object-parameters "Permalink to this headline")

* **PROJECT**: A Dataiku DSS project

* **DATASET**: Select exactly one dataset.

* **DATASETS**: One or more datasets.

* **DATASET\_COLUMN**: A column from a specified dataset. This type requires a `datasetParamName` to point to another parameter that has the type. See example below. (Note that this is probably not what you want for recipes, see the COLUMN type below)

* **DATASET\_COLUMNS**: One or more columns from a specified dataset.

* **MANAGED\_FOLDER**: A DSS managed folder (appear in the flow).

* **SAVED\_MODEL**: A DSS saved model (deployed version of a model that appears on the flow)

* **API\_SERVICE**: A DSS API service.

* **API\_SERVICE\_VERSION**: A version package among a specified API service. This type requires an `apiServiceParamName` to point to another parameter that has the type API\_SERVICE. See example below.

* **BUNDLE**: An automation bundle.

* **VISUAL\_ANALYSIS**: A visual analysis.

* **CONNECTIONS**: One or more connections.

* **SCENARIO**: A DSS scenario.

* **CODE\_ENV**: A DSS code environment.

* **PLUGIN**: A DSS plugin.

* **CLUSTER**: A DSS cluster.

Specific fields:

* `datasetParamName`: For DATASET\_COLUMN only. Parameter name of the related dataset.

* `apiServiceParamName`: For API\_SERVICE\_VERSION only. Parameter name of the related API Service.

* `canSelectForeign` (boolean, default false): For DATASET(S), MODEL and FOLDER only. Should this parameter show elements from other projects?

Example

§ {

§ "type": "DATASET",

§ "name": "mydataset",

§ "label": "Dataset to analyse"

§ },

§ {

§ "type": "DATASET\_COLUMN",

§ "name": "mycolumn",

§ "datasetParamName": "mydataset"

§ "label": "Column in the dataset to analyse"

§ }

### Selecting columns in plugin recipes[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#selecting-columns-in-plugin-recipes "Permalink to this headline")

In recipes, it’s common to want to select one or several columns from one of the input datasets. This is done using parameter types:

* **COLUMN**: Select exactly one column

* **COLUMNS**: select one or more columns

You will need to give the name of the *role* from which you want to select a column using `columnRole` field. Note that if the given role is multi-dataset, only the columns from the first dataset will be displayed.

Example:

§ {

§ "name": "incol",

§ "label": "Input column",

§ "type": "COLUMN",

§ "columnRole": "input\_role\_1"

§ }

Optionally, you can use the field `allowedColumnTypes` to trigger an error message when the user selects a column with an invalid storage type.

For example, the following COLUMN parameter will raise error messages for non-numerical columns:

§ {

§ "name": "numerical\_column",

§ "label": "Numerical column",

§ "type": "COLUMN",

§ "allowedColumnTypes": [

§ "tinyint",

§ "smallint",

§ "int",

§ "bigint",

§ "float",

§ "double"

§ ],

§ "columnRole": "input\_dataset",

§ "mandatory": true

§ }

You can choose the following storage types : `string`, `date`, `geopoint`, `geometry`, `array`, `map`, `object`, `boolean`, `double`, `float`, `bigint`, `int`, `smallint`, `tinyint`.

Note

* Custom preparation processors do not support the field `allowedColumnTypes`.

### Structured parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#structured-parameters "Permalink to this headline")

* **MAP**: A (key -> value) mapping

* **KEY\_VALUE\_LIST**: A list of (key -> value). Similar to MAP but with an order

### Separators[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#separators "Permalink to this headline")

Finally, there is a special parameter type called SEPARATOR, used just for display purposes to separate the form into sections.

## Conditional parameters[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#conditional-parameters "Permalink to this headline")

### Using visibilityCondition[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#using-visibilitycondition "Permalink to this headline")

#### Using visibilityCondition with a Boolean type[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#using-visibilitycondition-with-a-boolean-type "Permalink to this headline")

For example, the following JSON definition of the parameters :

§ "params": [

§ {

§ "name": "sep1",

§ "label": "Authentication",

§ "type": "SEPARATOR"

§ },

§ {

§ "name": "useToken",

§ "label" : "Authenticate with token",

§ "type": "BOOLEAN"

§ },

§ {

§ "name": "username",

§ "label" : "Login",

§ "type": "STRING",

§ "visibilityCondition" : "!model.useToken"

§ },

§ {

§ "name": "password",

§ "label" : "Password",

§ "type": "PASSWORD",

§ "visibilityCondition" : "!model.useToken"

§ },

§ {

§ "name": "token",

§ "label" : "Token",

§ "type": "STRING",

§ "visibilityCondition" : "model.useToken"

§ },

§ {

§ "name": "sep3",

§ "label": "Reads",

§ "type": "SEPARATOR"

§ },

§ {

§ "name": "fetchSize",

§ "label" : "Fetch size",

§ "type": "INT"

§ }

§ ]

produces the following form where the fields Token and Login/Password are shown/hidden depending on the state of the Authenticate with token checkbox:

#### Using visibilityCondition with a SELECT type[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#using-visibilitycondition-with-a-select-type "Permalink to this headline")

For example, the following JSON definition of the parameters :

§ "params": [

§ {

§ "name": "prediction\_type",

§ "label": "Regression or Classification",

§ "type": "SELECT",

§ "selectChoices" : [

§ { "value" : "regression", "label" : "Regression"},

§ { "value" : "classification", "label" : "Classification"}

§ ],

§ "mandatory": true

§ },

§ {

§ "name": "target\_actual\_col",

§ "label": "Target Column",

§ "type": "COLUMN",

§ "columnRole":"input\_dataset"

§ },

§ {

§ "name": "prediction\_probability\_col",

§ "label": "Prediction Probabilities Column",

§ "type": "COLUMN",

§ "columnRole":"input\_dataset",

§ "visibilityCondition" : "model.prediction\_type == 'classification'"

§ },

§ {

§ "name": "probability\_threshold",

§ "label": "Probability Threshold",

§ "type": "DOUBLE",

§ "defaultValue" : .5,

§ "visibilityCondition" : "model.prediction\_type == 'classification'"

§ },

§ {

§ "name": "prediction\_col",

§ "label": "Predictions Column Name",

§ "type": "COLUMN",

§ "columnRole":"input\_dataset",

§ "visibilityCondition" : "model.prediction\_type == 'regression'"

§ }

§ ],

produces the following form where the fields Prediction Probabilities Column and Probability Threshold are shown if Classification is selected as the prediction type, and Predictions Column Name is shown if Regression is selected:

### Dynamic select using python[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#dynamic-select-using-python "Permalink to this headline")

To populate the choices of a select using a python script, you need to:

* specify a SELECT param with `getChoicesFromPython: true`

* create a python file under the *resource* folder of the plugin (ex: “computechoices.py”) and create a do() function in it that returns a dict with a key “choices”

* point to the python file form the component json file by specifying `paramsPythonSetup: "computechoices.py"` (replace with the proper filename)

Example:

webapp.json file:

§ ...

§ "paramsPythonSetup": "compute\_available\_time\_slots.py"

§ "params": [

§ {

§ "type": "SELECT",

§ "name": "time\_slot",

§ "getChoicesFromPython": true

§ }

§ ],

§ ...

resource/compute\_available\_time\_slots.py

§ def do(payload, config, plugin\_config, inputs):

§ choices = [

§ { "value" : "val1", "label" : "Value 1"},

§ { "value" : "val2", "label" : "Value 2"}

§ ]

§ return {"choices": choices}

#### Optional fields[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#optional-fields "Permalink to this headline")

By default, the dynamic select will be triggered each time a parameter changes in the form. You may want to restrict the dynamic select trigger behaviour using the following options:

* `disableAutoReload`: The dynamic select python code will only be triggered at the load of the autoconfig form and not each time a parameter changes. Use this option as follow:

§ ...

§ "paramsPythonSetup": "compute\_available\_time\_slots.py"

§ "params": [

§ {

§ "name": "param\_A",

§ "label": "The param A",

§ "type": "DOUBLE",

§ "defaultValue" : .5

§ },

§ {

§ "name": "param\_B",

§ "label": "The param B",

§ "type": "DOUBLE",

§ "defaultValue" : .5

§ },

§ {

§ "type": "SELECT",

§ "name": "param\_C",

§ "getChoicesFromPython": true,

§ "disableAutoReload": true

§ }

§ ],

§ ...

In the above example, the param\_C will only be updated when the form is loaded. Further changes on param\_A or param\_B won’t call the python script and therefore field\_C will stay unchanged.

* `triggerParameters`: Restrict the dynamic select trigger on specific parameters changes. Particularly useful if your dynamic select only depends to specific parameters. Use this option as follow:

§ ...

§ "paramsPythonSetup": "compute\_available\_time\_slots.py"

§ "params": [

§ {

§ "name": "param\_A",

§ "label": "The param A",

§ "type": "DOUBLE",

§ "defaultValue" : .5

§ },

§ {

§ "name": "param\_B",

§ "label": "The param B",

§ "type": "DOUBLE",

§ "defaultValue" : .5

§ },

§ {

§ "type": "SELECT",

§ "name": "param\_C",

§ "getChoicesFromPython": true,

§ "triggerParameters": ["param\_B"]

§ }

§ ],

§ ...

In the above example, the param\_C will only be updated when the param\_B changes value.

### Fully custom UI[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#fully-custom-ui "Permalink to this headline")

You can specify fully custom HTML/JavaScript, see Other topics

## Plugin-level configuration[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#plugin-level-configuration "Permalink to this headline")

Just like each dataset and recipe can accept params, so can a plugin. Plugin-level configuration allows you to have a centralized configuration that is shared by all datasets and all recipes instances of this plugin.

Another characteristic of plugin-level config is that it’s only readable and writable by the Administrator. As such, it can be the right place to store API keys, credentials, connection strings, …

### Add settings to a plugin[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#add-settings-to-a-plugin "Permalink to this headline")

To add settings to a plugin, edit the plugin.json file and add a `"params"` array in the JSON top-level object. The structure of this params array is similar to the one of datasets and recipes.

### Read settings of a plugin[¶](https://doc.dataiku.com/dss/latest/plugins/reference/params.html#read-settings-of-a-plugin "Permalink to this headline")

* Datasets receive the plugin config (as a Python dict) in the constructor of their connector class. See the documentation of the Connector class or the automatically generated sample for more information.

* Python recipes can read the plugin config (as a Python dict) by calling the `dataiku.customrecipe.get\_plugin\_config()` function

* R recipes can read the plugin config by calling the `dataiku::dkuPluginConfig()` function
